package io.magus.methodmap;

import io.magus.methodmap.error.MapEntryKeyProductionException;

import java.lang.reflect.Method;
import java.util.Objects;

/**
 * Simple factory for generating map entry keys using the string list value of a
 * {@link io.magus.methodmap.StringKeys} annotation present on the target method.
 *
 * @author Enseart A. Simpson
 *
 */
public class StringKeysAnnotationKeyFactory implements MapEntryKeyFactory<String> {

	@Override
	public String[] produceMapEntryKeys(MethodHandleInfo methodHandleInfo)
			throws MapEntryKeyProductionException {

		Method method;
		StringKeys keysAnnotation;

		method = methodHandleInfo.getMethod();
		keysAnnotation = method.getAnnotation(StringKeys.class);

		if(keysAnnotation == null)
			throw new MapEntryKeyProductionException(String.format(
					"No StringKeys annotation found for method %s", Objects.toString(method)));

		return keysAnnotation.value();
	}

}
