package io.magus.methodmap;

import io.magus.methodmap.error.MethodCollectionProductionException;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;

import org.reflections.Reflections;

/**
 * MethodCollectionFactory that utilizes the Reflections library to generate method collections.
 *
 * @author Enseart A. Simpson
 *
 */
public class ReflectionsMethodCollectionFactory implements
		MethodCollectionFactory {

	protected static interface GetMethodsParams {
	}

	public static final class AnnotatedWithAnnotation implements GetMethodsParams {
		private final Annotation annotation;

		public AnnotatedWithAnnotation(Annotation annotation) {
			this.annotation = annotation;
		}

		public Annotation getAnnotation() {
			return annotation;
		}
	}

	public static final class AnnotatedWithAnnotationClass implements GetMethodsParams {
		private final Class<? extends Annotation> annotationClass;

		public AnnotatedWithAnnotationClass(Class<? extends Annotation> annotationClass) {
			this.annotationClass = annotationClass;
		}

		public Class<? extends Annotation> getAnnotationClass() {
			return annotationClass;
		}
	}

	public static final class MatchParams implements GetMethodsParams {
		private final Class<?>[] types;

		public MatchParams(Class<?>... types) {
			this.types = types;
		}

		public Class<?>[] getTypes() {
			return types;
		}
	}

	public static final class Returns implements GetMethodsParams {
		private final Class<?> returnType;

		public Returns(Class<?> returnType) {
			this.returnType = returnType;
		}

		public Class<?> getReturnType() {
			return returnType;
		}
	}

	public static final class WithAnyParamAnnotatedWithAnnotation implements GetMethodsParams {
		private final Annotation annotation;

		public WithAnyParamAnnotatedWithAnnotation(Annotation annotation) {
			this.annotation = annotation;
		}

		public Annotation getAnnotation() {
			return annotation;
		}
	}

	public static final class WithAnyParamAnnotatedWithAnnotationClass implements GetMethodsParams {
		private final Class<? extends Annotation> annotationClass;

		public WithAnyParamAnnotatedWithAnnotationClass(
				Class<? extends Annotation> annotationClass) {
			this.annotationClass = annotationClass;
		}

		public Class<? extends Annotation> getAnnotationClass() {
			return annotationClass;
		}
	}

	private final Reflections reflections;
	private final GetMethodsParams getMethodsParams;

	private ReflectionsMethodCollectionFactory(
			Reflections reflections, GetMethodsParams getMethodsParams) {
		this.reflections = reflections;
		this.getMethodsParams = getMethodsParams;
	}

	public ReflectionsMethodCollectionFactory(Reflections reflections,
			AnnotatedWithAnnotation annotatedWithAnnotation) {
		this(reflections, (GetMethodsParams)annotatedWithAnnotation);
	}

	public ReflectionsMethodCollectionFactory(Reflections reflections,
			AnnotatedWithAnnotationClass annotatedWithAnnotationClass) {
		this(reflections, (GetMethodsParams)annotatedWithAnnotationClass);
	}

	public ReflectionsMethodCollectionFactory(Reflections reflections, MatchParams matchParams) {
		this(reflections, (GetMethodsParams)matchParams);
	}

	public ReflectionsMethodCollectionFactory(Reflections reflections, Returns retrn) {
		this(reflections, (GetMethodsParams)retrn);
	}

	public ReflectionsMethodCollectionFactory(Reflections reflections,
			WithAnyParamAnnotatedWithAnnotation withAnyParamAnnotatedWithAnnotation) {
		this(reflections, (GetMethodsParams)withAnyParamAnnotatedWithAnnotation);
	}

	public ReflectionsMethodCollectionFactory(Reflections reflections,
			WithAnyParamAnnotatedWithAnnotationClass withAnyParamAnnotatedWithAnnotationClass) {
		this(reflections, (GetMethodsParams)withAnyParamAnnotatedWithAnnotationClass);
	}

	@Override
	public Collection<Method> produceMethodCollection()
			throws MethodCollectionProductionException {

		Collection<Method> result;

		if(getMethodsParams instanceof AnnotatedWithAnnotation) {
			result = reflections.getMethodsAnnotatedWith(
					((AnnotatedWithAnnotation)getMethodsParams).getAnnotation());

		} else if(getMethodsParams instanceof AnnotatedWithAnnotationClass) {
			result = reflections.getMethodsAnnotatedWith(
					((AnnotatedWithAnnotationClass)getMethodsParams).getAnnotationClass());

		} else if(getMethodsParams instanceof MatchParams) {
			result = reflections.getMethodsMatchParams(((MatchParams)getMethodsParams).getTypes());

		} else if(getMethodsParams instanceof Returns) {
			result = reflections.getMethodsReturn(((Returns)getMethodsParams).getReturnType());

		} else if(getMethodsParams instanceof WithAnyParamAnnotatedWithAnnotation) {
			result = reflections.getMethodsWithAnyParamAnnotated(
					((WithAnyParamAnnotatedWithAnnotation)getMethodsParams).getAnnotation());

		} else if(getMethodsParams instanceof WithAnyParamAnnotatedWithAnnotationClass) {
			result = reflections.getMethodsWithAnyParamAnnotated(
					((WithAnyParamAnnotatedWithAnnotationClass)getMethodsParams)
						.getAnnotationClass());

		} else {
			result = null;
		}

		return result;
	}

}
