package io.magus.methodmap;

import io.magus.methodmap.error.MethodCollectionProductionException;

import java.lang.reflect.Method;
import java.util.Collection;

/**
 * Interface encapsulating the factory pattern used to produce method collections for
 * implementations of {@link io.magus.methodmap.AbstractMethodMap}.
 *
 * @author Enseart A. Simpson
 *
 */
public interface MethodCollectionFactory {

	/**
	 * @return										the collection of methods
	 * @throws MethodCollectionProductionException	If production of the method collection fails.
	 *
	 */
	public Collection<Method> produceMethodCollection() throws MethodCollectionProductionException;
}
