package io.magus.methodmap;

import io.magus.methodmap.error.MapEntryKeyProductionException;

/**
 * Interface encapsulating the factory pattern used to produce map entry keys for implementations of
 * {@link io.magus.methodmap.AbstractMethodMap}.
 *
 * @author Enseart A. Simpson
 *
 * @param <K>	Type of the keys that will be produced by this factory.
 *
 */
public interface MapEntryKeyFactory<K> {

	/**
	 * @param methodHandleInfo					the methodhandleinfo for which the keys are to be
	 * 											produced
	 * @return									array of keys the provided methodhandleinfo should
	 * 											be mapped to
	 * @throws MapEntryKeyProductionException	If keys cannot be produced.
	 */
	public K[] produceMapEntryKeys(MethodHandleInfo methodHandleInfo)
			throws MapEntryKeyProductionException;
}
