package io.magus.methodmap;

import java.util.Arrays;

/**
 * Utility class for splitting up an array of objects into a key and an array of arguments.
 *
 * @author Enseart A. Simpson
 *
 * @param <K>	Type of the key
 */
public class KeyArgsPair<K> {

	private final K key;
	private final Object[] args;

	@SuppressWarnings("unchecked")
	public KeyArgsPair(Object... args) {
		if(args == null || args.length == 0 ) {
			key = null;
			this.args = null;
		} else {
			key = (K)args[0];
			this.args = Arrays.copyOfRange(args, 1, args.length);
		}

	}

	/**
	 * Retrieves the key of this keyargspair.
	 *
	 * @return	the key of this keyargspair
	 */
	public K getKey() {
		return key;
	}

	/**
	 * Retrieves the arguments of this keyargspair.
	 *
	 * @return	the arguments of this keyargspair
	 */
	public Object[] getArgs() {
		return args;
	}
}
