package io.magus.methodmap;

import io.magus.methodmap.error.MapEntryKeyProductionException;

import java.lang.reflect.Method;

/**
 * {@linkplain io.magus.methodmap.MapEntryKeyFactory} for string-keyed MethodMaps.
 * Produces unique keys across all Methods by utilizing their fully qualified method signatures.
 *
 * @author Enseart A. Simpson
 *
 */
public class FullSignatureEntryKeyFactory implements MapEntryKeyFactory<String> {

	private final String signatureComponentSeparator;

	/**
	 * @param signatureComponentSeparator	delimiter used to separate each component of the
	 * 										produced signature
	 */
	public FullSignatureEntryKeyFactory(String signatureComponentSeparator) {
		this.signatureComponentSeparator = signatureComponentSeparator;
	}

	@Override
	public String[] produceMapEntryKeys(MethodHandleInfo methodHandleInfo)
			throws MapEntryKeyProductionException {
		Method method;
		Class<?> clazz;
		String className, methodName;
		Class<?>[] parameterTypes;
		StringBuilder stringBuilder;
		int keyLength;

		method = methodHandleInfo.getMethod();
		clazz = method.getDeclaringClass();

		className = clazz.getName();
		methodName = method.getName();

		keyLength = className.length() + methodName.length() + 1;

		parameterTypes = method.getParameterTypes();
		for(Class<?> parameterType : parameterTypes)
			keyLength += parameterType.getName().length() + 1;

		stringBuilder = new StringBuilder(keyLength).append(className)
				.append(signatureComponentSeparator).append(methodName);

		for(Class<?> parameterType : parameterTypes)
			stringBuilder.append(signatureComponentSeparator)
			.append(parameterType.getName());

		return new String[]{stringBuilder.toString()};
	}
}
