package io.magus.methodmap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

/**
 * {@link io.magus.methodmap.AbstractBoundMethodCollectionFactory BoundMethodCollectionFactory} that
 * produces a method collection consisting solely of methods from the class of the provided object
 * that are annotated with the provided annotation class.
 *
 * @author Enseart A. Simpson
 *
 */
public class BoundAnnotatedMethodCollectionFactory extends
		AbstractBoundMethodCollectionFactory {

	private final Class<? extends Annotation> annotationClass;

	/**
	 * @param target			the target object
	 * @param annotationClass	the annotation class that indicates the methods to be included
	 *
	 */
	public BoundAnnotatedMethodCollectionFactory(
			Object target, Class<? extends Annotation> annotationClass) {
		super(target);
		this.annotationClass = annotationClass;
	}

	@Override
	protected boolean include(Method method) {
		return method.isAnnotationPresent(annotationClass);
	}

}
