package io.magus.methodmap;

import io.magus.methodmap.error.ArgsProductionException;

/**
 * Interface that encapsulates the factory pattern used for generating arguments for calls to
 * {@code invoke} in subclasses of {@link io.magus.methodmap.AbstractMethodMap}.
 *
 * @author Enseart A. Simpson
 *
 */
public interface ArgsFactory {

	/**
	 * Interface method called by {@code invoke} in subclasses of
	 * {@link io.magus.methodmap.AbstractMethodMap} to generate the arguments.
	 *
	 * @param methodHandleInfo			the methodhandleinfo that contains the methodhandle to be
	 * 									invoked
	 * @return							the array of arguments to be passed to the methodhandle
	 * 									contained in the provided methodhandleinfo
	 * @throws ArgsProductionException	If the arguments cannot be produced.
	 *
	 * @see								io.magus.methodmap.AbstractMethodMap#invoke(MethodHandleInfo, ArgsFactory)
	 * @see								io.magus.methodmap.AbstractMethodMap#invoke(Object, ArgsFactory)
	 * @see								io.magus.methodmap.AutoInstantiatingMethodMap#invoke(MethodHandleInfo, ArgsFactory)
	 * @see								io.magus.methodmap.AutoInstantiatingMethodMap#invoke(Object, ArgsFactory)
	 * @see								io.magus.methodmap.AutoInstantiatingMethodMap#invoke(MethodHandleInfo, Class[], Object[], ArgsFactory)
	 * @see								io.magus.methodmap.AutoInstantiatingMethodMap#invoke(Object, Class[], Object[], ArgsFactory)
	 *
	 */
	public Object[] produceArgs(MethodHandleInfo methodHandleInfo) throws ArgsProductionException;
}
