/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.common.serialization.utils;

import io.macronova.kafka.common.serialization.utils.IOUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.kafka.common.errors.SerializationException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public abstract class EncryptionHelper {
    private static final BouncyCastleProvider provider = new BouncyCastleProvider();
    private static final SecureRandom random = new SecureRandom();

    public static Cipher initializeCipher(int mode, String transformation, Key key, InputStream inputStream, OutputStream outputStream) throws Exception {
        Cipher cipher = Cipher.getInstance(transformation, (Provider)provider);
        if (EncryptionHelper.requiresIV(transformation)) {
            byte[] iv = null;
            switch (mode) {
                case 1: {
                    iv = EncryptionHelper.randomIV(transformation, cipher);
                    outputStream.write(iv);
                    break;
                }
                case 2: {
                    int ivLength = EncryptionHelper.ivLength(transformation, cipher);
                    iv = new byte[ivLength];
                    if (inputStream.read(iv) == ivLength) break;
                    throw new SerializationException("Unexpected end of encrypted content.");
                }
            }
            cipher.init(mode, key, new IvParameterSpec(iv));
        } else {
            cipher.init(mode, key);
        }
        return cipher;
    }

    public static Cipher initializeCipher(int mode, String transformation, byte[] secret, InputStream inputStream, OutputStream outputStream) throws Exception {
        Cipher cipher = Cipher.getInstance(transformation, (Provider)provider);
        SecretKeySpec keySpec = new SecretKeySpec(secret, EncryptionHelper.extractAlgorithm(transformation));
        if (EncryptionHelper.requiresIV(transformation)) {
            byte[] iv = null;
            switch (mode) {
                case 1: {
                    iv = EncryptionHelper.randomIV(transformation, cipher);
                    outputStream.write(iv);
                    break;
                }
                case 2: {
                    int ivLength = EncryptionHelper.ivLength(transformation, cipher);
                    iv = new byte[ivLength];
                    if (inputStream.read(iv) == ivLength) break;
                    throw new SerializationException("Unexpected end of encrypted content.");
                }
            }
            cipher.init(mode, (Key)keySpec, new IvParameterSpec(iv));
        } else {
            cipher.init(mode, keySpec);
        }
        return cipher;
    }

    public static Signature initializeSignature(String algorithm, Key key, boolean sign) throws Exception {
        Signature signature = Signature.getInstance(algorithm, (Provider)provider);
        if (sign) {
            signature.initSign((PrivateKey)key, random);
        } else {
            signature.initVerify((PublicKey)key);
        }
        return signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore(String keystorePath, String type, char[] password) throws Exception {
        KeyStore keyStore;
        FileInputStream keyStoreStream = null;
        try {
            KeyStore keyStore2 = KeyStore.getInstance(type);
            keyStoreStream = new FileInputStream(keystorePath);
            keyStore2.load(keyStoreStream, password);
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(keyStoreStream);
            throw throwable;
        }
        IOUtils.closeQuietly(keyStoreStream);
        return keyStore;
    }

    public static int getKeyLength(PublicKey pk) {
        int len = -1;
        if (pk instanceof RSAPublicKey) {
            RSAPublicKey rsa = (RSAPublicKey)pk;
            len = rsa.getModulus().bitLength();
        } else if (pk instanceof ECPublicKey) {
            ECPublicKey ec = (ECPublicKey)pk;
            ECParameterSpec spec = ec.getParams();
            len = spec.getOrder().bitLength();
        } else if (pk instanceof DSAPublicKey) {
            DSAPublicKey dsa = (DSAPublicKey)pk;
            len = dsa.getParams() != null ? dsa.getParams().getP().bitLength() : dsa.getY().bitLength();
        }
        return len;
    }

    public static int getKeyLength(PrivateKey pk) {
        int len = -1;
        if (pk instanceof RSAPrivateKey) {
            RSAPrivateKey rsa = (RSAPrivateKey)pk;
            len = rsa.getModulus().bitLength();
        } else if (pk instanceof ECPrivateKey) {
            ECPrivateKey ec = (ECPrivateKey)pk;
            ECParameterSpec spec = ec.getParams();
            len = spec.getOrder().bitLength();
        } else if (pk instanceof DSAPrivateKey) {
            DSAPrivateKey dsa = (DSAPrivateKey)pk;
            len = dsa.getParams() != null ? dsa.getParams().getP().bitLength() : dsa.getX().bitLength();
        }
        return len;
    }

    public static boolean requiresIV(String transformation) {
        return transformation.contains("/CBC/") || transformation.contains("/CTR/") || transformation.contains("/CCM/") || transformation.contains("/GCM/") || transformation.contains("/OFB/") || transformation.contains("/OCB/");
    }

    public static int ivLength(String transformation, Cipher cipher) {
        if (transformation.contains("/CBC/")) {
            return cipher.getBlockSize();
        }
        if (transformation.contains("/CCM/") || transformation.contains("/GCM/") || transformation.contains("/OCB/")) {
            return 12;
        }
        return 16;
    }

    public static String extractAlgorithm(String transformation) {
        return transformation.contains("/") ? transformation.substring(0, transformation.indexOf("/")) : transformation;
    }

    public static byte[] randomIV(String transformation, Cipher cipher) {
        byte[] randomIV = new byte[EncryptionHelper.ivLength(transformation, cipher)];
        random.nextBytes(randomIV);
        return randomIV;
    }
}

