/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.common.serialization.config;

import io.macronova.kafka.common.serialization.config.BaseEncryptConfig;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class DecryptDeserializerConfig
extends BaseEncryptConfig {
    private static ConfigDef config = DecryptDeserializerConfig.baseConfigDef();
    public static final String KEY_ALIAS_PASSWORD_CONFIG = "key.store.alias.password";
    public static final String KEY_ALIAS_PASSWORD_DOC = "Password to access private key present in key store. Required in case of certificate decryption.";

    public DecryptDeserializerConfig(Map<?, ?> originals) {
        super(config, originals);
        this.validate();
    }

    protected static ConfigDef baseConfigDef() {
        ConfigDef config = BaseEncryptConfig.baseConfigDef();
        config.define(KEY_ALIAS_PASSWORD_CONFIG, ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, KEY_ALIAS_PASSWORD_DOC);
        return config;
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.useCertificate() && this.getPassword(KEY_ALIAS_PASSWORD_CONFIG) == null) {
            throw new ConfigException(String.format("Property '%s' cannot be empty when declared '%s'.", KEY_ALIAS_PASSWORD_CONFIG, "key.store.path"));
        }
    }

    public String getKeyAliasPassword() {
        return this.getPassword(KEY_ALIAS_PASSWORD_CONFIG).value();
    }
}

