/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.common.serialization.config;

import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;

public abstract class BaseEncryptConfig
extends AbstractConfig {
    public static final String TRANSFORMATION_CONFIG = "transformation";
    public static final String TRANSFORMATION_DOC = "Cryptography transformation that consists of algorithm, mode and padding. Example: AES/CBC/PKCS5Padding.";
    public static final String KEY_STORE_PATH_CONFIG = "key.store.path";
    public static final String KEY_STORE_PATH_DOC = "Path to Java keystore. Required in case of certificate encryption.";
    public static final String KEY_STORE_PASSWORD_CONFIG = "key.store.password";
    public static final String KEY_STORE_PASSWORD_DOC = "Java keystore password. Required in case of certificate encryption.";
    public static final String KEY_STORE_TYPE_CONFIG = "key.store.type";
    public static final String KEY_STORE_TYPE_DEFAULT = "JKS";
    public static final String KEY_STORE_TYPE_DOC = "Java keystore type. Default: JKS.";
    public static final String KEY_ALIAS_CONFIG = "key.store.alias";
    public static final String KEY_ALIAS_DOC = "Alias of the key present in key store. Required in case of certificate encryption.";
    public static final String SECRET_CONFIG = "secret";
    public static final String SECRET_DOC = "Encryption key in hexadecimal format. Required in case of passphrase encryption.";

    public BaseEncryptConfig(ConfigDef definition, Map<?, ?> originals) {
        super(definition, originals, false);
    }

    protected static ConfigDef baseConfigDef() {
        return new ConfigDef().define(TRANSFORMATION_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, TRANSFORMATION_DOC).define(KEY_STORE_PATH_CONFIG, ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, KEY_STORE_PATH_DOC).define(KEY_STORE_PASSWORD_CONFIG, ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, KEY_STORE_PASSWORD_DOC).define(KEY_STORE_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)KEY_STORE_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, KEY_STORE_TYPE_DOC).define(KEY_ALIAS_CONFIG, ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, KEY_ALIAS_DOC).define(SECRET_CONFIG, ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, SECRET_DOC);
    }

    protected void validate() {
        if (this.getString(KEY_STORE_PATH_CONFIG) == null && this.getPassword(SECRET_CONFIG) == null || this.getString(KEY_STORE_PATH_CONFIG) != null && this.getPassword(SECRET_CONFIG) != null) {
            throw new ConfigException(String.format("Exactly one of the following properties need to be specified: %s, %s.", KEY_STORE_PATH_CONFIG, SECRET_CONFIG));
        }
        if (this.useCertificate()) {
            if (this.getPassword(KEY_STORE_PASSWORD_CONFIG) == null) {
                throw new ConfigException(String.format("Property '%s' cannot be empty when declared '%s'.", KEY_STORE_PASSWORD_CONFIG, KEY_STORE_PATH_CONFIG));
            }
            if (this.getString(KEY_ALIAS_CONFIG) == null) {
                throw new ConfigException(String.format("Property '%s' cannot be empty when declared '%s'.", KEY_ALIAS_CONFIG, KEY_STORE_PATH_CONFIG));
            }
        }
    }

    public boolean useCertificate() {
        return this.getString(KEY_STORE_PATH_CONFIG) != null;
    }

    public String getTransformation() {
        return this.getString(TRANSFORMATION_CONFIG);
    }

    public byte[] getSecret() {
        Password secret = this.getPassword(SECRET_CONFIG);
        if (secret != null) {
            return DatatypeConverter.parseHexBinary((String)secret.value());
        }
        return null;
    }

    public String getKeyStorePath() {
        return this.getString(KEY_STORE_PATH_CONFIG);
    }

    public String getKeyStorePassword() {
        return this.getPassword(KEY_STORE_PASSWORD_CONFIG).value();
    }

    public String getKeyStoreType() {
        return this.getString(KEY_STORE_TYPE_CONFIG);
    }

    public String getKeyAlias() {
        return this.getString(KEY_ALIAS_CONFIG);
    }
}

