/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.common.serialization;

import io.macronova.kafka.common.serialization.config.VerifySignatureConfig;
import io.macronova.kafka.common.serialization.utils.EncryptionHelper;
import io.macronova.kafka.common.serialization.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class VerifySignatureDeserializer
implements Deserializer<byte[]> {
    private VerifySignatureConfig config = null;
    private PublicKey publicKey = null;

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.config = new VerifySignatureConfig(configs);
        try {
            KeyStore keyStore = EncryptionHelper.loadKeyStore(this.config.getKeyStorePath(), this.config.getKeyStoreType(), this.config.getKeyStorePassword().toCharArray());
            Certificate certificate = keyStore.getCertificate(this.config.getKeyAlias());
            if (certificate == null) {
                throw new ConfigException(String.format("Could not find alias '%s' in key store '%s'.", this.config.getKeyAlias(), this.config.getKeyStorePath()));
            }
            this.publicKey = certificate.getPublicKey();
        }
        catch (Exception e) {
            throw new ConfigException(String.format("Failed to retrieve public key: %s.", e.getMessage()), (Object)e);
        }
    }

    public byte[] deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        try {
            Signature signature = EncryptionHelper.initializeSignature(this.config.getAlgorithm(), this.publicKey, false);
            byte[] proposedSignature = new byte[EncryptionHelper.getKeyLength(this.publicKey) / 8];
            if (inputStream.read(proposedSignature) != proposedSignature.length) {
                throw new SerializationException("Unexpected end of encrypted content.");
            }
            byte[] buffer = new byte[8192];
            int bytesCount = 0;
            while ((bytesCount = inputStream.read(buffer)) != -1) {
                signature.update(buffer, 0, bytesCount);
            }
            boolean valid = signature.verify(proposedSignature);
            if (!valid) {
                throw new SerializationException("Incorrect signature.");
            }
            byte[] byArray = Arrays.copyOfRange(data, proposedSignature.length, data.length);
            return byArray;
        }
        catch (Exception e) {
            throw new SerializationException(String.format("Failed to verify signature: %s.", e.getMessage()), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public void close() {
        this.config = null;
        this.publicKey = null;
    }
}

