/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.common.serialization;

import io.macronova.kafka.common.serialization.config.HybridEncryptSerializerConfig;
import io.macronova.kafka.common.serialization.utils.EncryptionHelper;
import io.macronova.kafka.common.serialization.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class HybridEncryptSerializer
implements Serializer<byte[]> {
    private static final SecureRandom random = new SecureRandom();
    private HybridEncryptSerializerConfig config = null;
    private PublicKey publicKey = null;

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.config = new HybridEncryptSerializerConfig(configs);
        try {
            KeyStore keyStore = EncryptionHelper.loadKeyStore(this.config.getAsymmetricKeyStorePath(), this.config.getAsymmetricKeyStoreType(), this.config.getAsymmetricKeyStorePassword().toCharArray());
            Certificate certificate = keyStore.getCertificate(this.config.getAsymmetricKeyAlias());
            if (certificate == null) {
                throw new ConfigException(String.format("Could not find alias '%s' in key store '%s'.", this.config.getAsymmetricKeyAlias(), this.config.getAsymmetricKeyStorePath()));
            }
            this.publicKey = certificate.getPublicKey();
        }
        catch (Exception e) {
            throw new ConfigException(String.format("Failed to retrieve public key: %s.", e.getMessage()), (Object)e);
        }
    }

    public byte[] serialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(EncryptionHelper.extractAlgorithm(this.config.getSymmetricTransformation()));
            keyGenerator.init(EncryptionHelper.getKeyLength(this.publicKey) / 8, random);
            SecretKey secretKey = keyGenerator.generateKey();
            Cipher asymmetricCipher = EncryptionHelper.initializeCipher(1, this.config.getAsymmetricTransformation(), this.publicKey, null, (OutputStream)outputStream);
            ByteArrayInputStream keyInputStream = new ByteArrayInputStream(secretKey.getEncoded());
            CipherInputStream cipherInputStream = new CipherInputStream(keyInputStream, asymmetricCipher);
            IOUtils.copy(cipherInputStream, outputStream);
            ((InputStream)keyInputStream).close();
            cipherInputStream.close();
            Cipher symmetricCipher = EncryptionHelper.initializeCipher(1, this.config.getSymmetricTransformation(), secretKey.getEncoded(), null, (OutputStream)outputStream);
            cipherInputStream = new CipherInputStream(inputStream, symmetricCipher);
            IOUtils.copy(cipherInputStream, outputStream);
            cipherInputStream.close();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new SerializationException(String.format("Failed to encrypt content: %s.", e.getMessage()), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(outputStream);
        }
    }

    public void close() {
        this.config = null;
        this.publicKey = null;
    }
}

