/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.common.serialization;

import io.macronova.kafka.common.serialization.config.HybridDecryptDeserializerConfig;
import io.macronova.kafka.common.serialization.utils.EncryptionHelper;
import io.macronova.kafka.common.serialization.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class HybridDecryptDeserializer
implements Deserializer<byte[]> {
    private HybridDecryptDeserializerConfig config = null;
    private PrivateKey privateKey = null;

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.config = new HybridDecryptDeserializerConfig(configs);
        try {
            KeyStore keyStore = EncryptionHelper.loadKeyStore(this.config.getAsymmetricKeyStorePath(), this.config.getAsymmetricKeyStoreType(), this.config.getAsymmetricKeyStorePassword().toCharArray());
            KeyStore.PasswordProtection keyPassword = new KeyStore.PasswordProtection(this.config.getAsymmetricKeyAliasPassword().toCharArray());
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(this.config.getAsymmetricKeyAlias(), keyPassword);
            if (privateKeyEntry == null) {
                throw new ConfigException(String.format("Could not find alias '%s' in key store '%s'.", this.config.getAsymmetricKeyAlias(), this.config.getAsymmetricKeyStorePath()));
            }
            this.privateKey = privateKeyEntry.getPrivateKey();
        }
        catch (Exception e) {
            throw new ConfigException(String.format("Failed to retrieve private key: %s.", e.getMessage()), (Object)e);
        }
    }

    public byte[] deserialize(String topic, byte[] data) {
        byte[] byArray;
        if (data == null) {
            return null;
        }
        ByteArrayInputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            inputStream = new ByteArrayInputStream(data);
            outputStream = new ByteArrayOutputStream();
            Cipher asymmetricCipher = EncryptionHelper.initializeCipher(2, this.config.getAsymmetricTransformation(), this.privateKey, (InputStream)inputStream, null);
            byte[] keyEncrypted = new byte[EncryptionHelper.getKeyLength(this.privateKey) / 8];
            if (inputStream.read(keyEncrypted) != keyEncrypted.length) {
                throw new SerializationException("Unexpected end of encrypted content.");
            }
            ByteArrayInputStream keyInputStream = new ByteArrayInputStream(keyEncrypted);
            ByteArrayOutputStream keyOutputStream = new ByteArrayOutputStream();
            CipherInputStream cipherInputStream = new CipherInputStream(keyInputStream, asymmetricCipher);
            IOUtils.copy(cipherInputStream, keyOutputStream);
            keyInputStream.close();
            cipherInputStream.close();
            keyOutputStream.close();
            byte[] keyDecrypted = keyOutputStream.toByteArray();
            Cipher symmetricCipher = EncryptionHelper.initializeCipher(2, this.config.getSymmetricTransformation(), keyDecrypted, (InputStream)inputStream, null);
            cipherInputStream = new CipherInputStream(inputStream, symmetricCipher);
            IOUtils.copy(cipherInputStream, outputStream);
            cipherInputStream.close();
            byArray = outputStream.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new SerializationException(String.format("Failed to decrypt content: %s.", e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        IOUtils.closeQuietly(outputStream);
        return byArray;
    }

    public void close() {
        this.config = null;
        this.privateKey = null;
    }
}

