/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.common.serialization;

import io.macronova.kafka.common.serialization.config.GenerateSignatureConfig;
import io.macronova.kafka.common.serialization.utils.EncryptionHelper;
import io.macronova.kafka.common.serialization.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Arrays;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class GenerateSignatureSerializer
implements Serializer<byte[]> {
    private GenerateSignatureConfig config = null;
    private PrivateKey privateKey = null;

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.config = new GenerateSignatureConfig(configs);
        try {
            KeyStore keyStore = EncryptionHelper.loadKeyStore(this.config.getKeyStorePath(), this.config.getKeyStoreType(), this.config.getKeyStorePassword().toCharArray());
            KeyStore.PasswordProtection keyPassword = new KeyStore.PasswordProtection(this.config.getKeyAliasPassword().toCharArray());
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(this.config.getKeyAlias(), keyPassword);
            if (privateKeyEntry == null) {
                throw new ConfigException(String.format("Could not find alias '%s' in key store '%s'.", this.config.getKeyAlias(), this.config.getKeyStorePath()));
            }
            this.privateKey = privateKeyEntry.getPrivateKey();
        }
        catch (Exception e) {
            throw new ConfigException(String.format("Failed to retrieve private key: %s.", e.getMessage()), (Object)e);
        }
    }

    public byte[] serialize(String topic, byte[] data) {
        byte[] byArray;
        if (data == null) {
            return null;
        }
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(data);
            Signature signature = EncryptionHelper.initializeSignature(this.config.getAlgorithm(), this.privateKey, true);
            byte[] buffer = new byte[8192];
            int bytesCount = 0;
            while ((bytesCount = inputStream.read(buffer)) != -1) {
                signature.update(buffer, 0, bytesCount);
            }
            byte[] signatureBytes = signature.sign();
            byte[] output = Arrays.copyOf(signatureBytes, data.length + signatureBytes.length);
            System.arraycopy(data, 0, output, signatureBytes.length, data.length);
            byArray = output;
        }
        catch (Exception e) {
            try {
                throw new SerializationException(String.format("Failed to sign content: %s.", e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return byArray;
    }

    public void close() {
        this.config = null;
        this.privateKey = null;
    }
}

