/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.common.serialization;

import io.macronova.kafka.common.serialization.config.EncryptSerializerConfig;
import io.macronova.kafka.common.serialization.utils.EncryptionHelper;
import io.macronova.kafka.common.serialization.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class EncryptSerializer
implements Serializer<byte[]> {
    private EncryptSerializerConfig config = null;
    private PublicKey publicKey = null;

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.config = new EncryptSerializerConfig(configs);
        if (this.config.useCertificate()) {
            try {
                KeyStore keyStore = EncryptionHelper.loadKeyStore(this.config.getKeyStorePath(), this.config.getKeyStoreType(), this.config.getKeyStorePassword().toCharArray());
                Certificate certificate = keyStore.getCertificate(this.config.getKeyAlias());
                if (certificate == null) {
                    throw new ConfigException(String.format("Could not find alias '%s' in key store '%s'.", this.config.getKeyAlias(), this.config.getKeyStorePath()));
                }
                this.publicKey = certificate.getPublicKey();
            }
            catch (Exception e) {
                throw new ConfigException(String.format("Failed to retrieve public key: %s.", e.getMessage()), (Object)e);
            }
        }
    }

    public byte[] serialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Cipher cipher = this.config.useCertificate() ? EncryptionHelper.initializeCipher(1, this.config.getTransformation(), this.publicKey, null, (OutputStream)outputStream) : EncryptionHelper.initializeCipher(1, this.config.getTransformation(), this.config.getSecret(), null, (OutputStream)outputStream);
            CipherInputStream cipherInputStream = new CipherInputStream(inputStream, cipher);
            IOUtils.copy(cipherInputStream, outputStream);
            cipherInputStream.close();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new SerializationException(String.format("Failed to encrypt content: %s.", e.getMessage()), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(outputStream);
        }
    }

    public void close() {
        this.config = null;
        this.publicKey = null;
    }
}

