/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.common.serialization;

import io.macronova.kafka.common.serialization.config.DecryptDeserializerConfig;
import io.macronova.kafka.common.serialization.utils.EncryptionHelper;
import io.macronova.kafka.common.serialization.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class DecryptDeserializer
implements Deserializer<byte[]> {
    private DecryptDeserializerConfig config = null;
    private PrivateKey privateKey = null;

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.config = new DecryptDeserializerConfig(configs);
        if (this.config.useCertificate()) {
            try {
                KeyStore keyStore = EncryptionHelper.loadKeyStore(this.config.getKeyStorePath(), this.config.getKeyStoreType(), this.config.getKeyStorePassword().toCharArray());
                KeyStore.PasswordProtection keyPassword = new KeyStore.PasswordProtection(this.config.getKeyAliasPassword().toCharArray());
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(this.config.getKeyAlias(), keyPassword);
                if (privateKeyEntry == null) {
                    throw new ConfigException(String.format("Could not find alias '%s' in key store '%s'.", this.config.getKeyAlias(), this.config.getKeyStorePath()));
                }
                this.privateKey = privateKeyEntry.getPrivateKey();
            }
            catch (Exception e) {
                throw new ConfigException(String.format("Failed to retrieve private key: %s.", e.getMessage()), (Object)e);
            }
        }
    }

    public byte[] deserialize(String topic, byte[] data) {
        byte[] byArray;
        if (data == null) {
            return null;
        }
        ByteArrayInputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            inputStream = new ByteArrayInputStream(data);
            outputStream = new ByteArrayOutputStream();
            Cipher cipher = this.config.useCertificate() ? EncryptionHelper.initializeCipher(2, this.config.getTransformation(), this.privateKey, (InputStream)inputStream, null) : EncryptionHelper.initializeCipher(2, this.config.getTransformation(), this.config.getSecret(), (InputStream)inputStream, null);
            CipherInputStream cipherInputStream = new CipherInputStream(inputStream, cipher);
            IOUtils.copy(cipherInputStream, outputStream);
            cipherInputStream.close();
            byArray = outputStream.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new SerializationException(String.format("Failed to decrypt content: %s.", e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        IOUtils.closeQuietly(outputStream);
        return byArray;
    }

    public void close() {
        this.config = null;
        this.privateKey = null;
    }
}

