/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.common.serialization;

import io.macronova.kafka.common.serialization.BaseChainedSerDe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Serializer;

public class ChainedSerializer
extends BaseChainedSerDe
implements Serializer<Object> {
    public static final String SERIALIZER_CLASS_CONFIG = "serializer";
    private final List<Serializer<Object>> serializers = new ArrayList<Serializer<Object>>();

    public void configure(Map<String, ?> configs, boolean isKey) {
        Map<Integer, Map<String, Object>> configuration = this.parseChainConfigurations(configs);
        int position = 0;
        while (configuration.containsKey(position)) {
            this.serializers.add(this.createSerializer(position, configuration.get(position), isKey));
            ++position;
        }
        if (this.serializers.isEmpty()) {
            throw new ConfigException(String.format("No serializers configured. Please define '0.%s' property.", SERIALIZER_CLASS_CONFIG));
        }
    }

    private Serializer<Object> createSerializer(int position, Map<String, Object> config, boolean isKey) {
        String serializerClass = (String)config.get(SERIALIZER_CLASS_CONFIG);
        if (serializerClass == null) {
            throw new ConfigException(String.format("Please specify property '%d.%s' which should reflect child serializer class.", position, SERIALIZER_CLASS_CONFIG));
        }
        try {
            Serializer serializer = (Serializer)Class.forName(serializerClass).newInstance();
            serializer.configure(config, isKey);
            return serializer;
        }
        catch (Exception e) {
            throw new ConfigException(String.format("Failed to instantiate serializer [%s]: %s.", serializerClass, e.getMessage()));
        }
    }

    public byte[] serialize(String topic, Object data) {
        Object result = data;
        for (Serializer<Object> serializer : this.serializers) {
            result = serializer.serialize(topic, result);
        }
        return (byte[])result;
    }

    public void close() {
        this.serializers.clear();
    }
}

