/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.common.serialization;

import io.macronova.kafka.common.serialization.BaseChainedSerDe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Deserializer;

public class ChainedDeserializer
extends BaseChainedSerDe
implements Deserializer<Object> {
    public static final String DESERIALIZER_CLASS_CONFIG = "deserializer";
    private final List<Deserializer<Object>> deserializers = new ArrayList<Deserializer<Object>>();

    public void configure(Map<String, ?> configs, boolean isKey) {
        Map<Integer, Map<String, Object>> configuration = this.parseChainConfigurations(configs);
        int position = 0;
        while (configuration.containsKey(position)) {
            this.deserializers.add(this.createDeserializer(position, configuration.get(position), isKey));
            ++position;
        }
        if (this.deserializers.isEmpty()) {
            throw new ConfigException(String.format("No deserializers configured. Please define '0.%s' property.", DESERIALIZER_CLASS_CONFIG));
        }
    }

    private Deserializer<Object> createDeserializer(int position, Map<String, Object> config, boolean isKey) {
        String deserializerClass = (String)config.get(DESERIALIZER_CLASS_CONFIG);
        if (deserializerClass == null) {
            throw new ConfigException(String.format("Please specify property '%d.%s' which should reflect child deserializer class.", position, DESERIALIZER_CLASS_CONFIG));
        }
        try {
            Deserializer deserializer = (Deserializer)Class.forName(deserializerClass).newInstance();
            deserializer.configure(config, isKey);
            return deserializer;
        }
        catch (Exception e) {
            throw new ConfigException(String.format("Failed to instantiate deserializer [%s]: %s.", deserializerClass, e.getMessage()));
        }
    }

    public Object deserialize(String topic, byte[] data) {
        Object result = data;
        for (Deserializer<Object> deserializer : this.deserializers) {
            result = deserializer.deserialize(topic, result);
        }
        return result;
    }

    public void close() {
        this.deserializers.clear();
    }
}

