/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.connect.jms.util;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;

public abstract class JmsUtils {
    public static String destinationName(Destination destination) throws JMSException {
        if (destination instanceof Queue) {
            return ((Queue)destination).getQueueName();
        }
        if (destination instanceof Topic) {
            return ((Topic)destination).getTopicName();
        }
        return null;
    }

    public static String destinationType(Destination destination) {
        if (destination == null) {
            return null;
        }
        return destination instanceof Queue ? "queue" : "topic";
    }

    public static String messageIdForLog(Message message) {
        try {
            return message.getJMSMessageID();
        }
        catch (JMSException e) {
            return "unknown";
        }
    }

    public static String destinationNameForLog(Destination destination) {
        try {
            return JmsUtils.destinationName(destination);
        }
        catch (JMSException e) {
            return "unknown";
        }
    }
}

