/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.connect.jms.source;

import io.macronova.kafka.connect.jms.common.BaseConnectorConfig;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class JmsSourceConnectorConfig
extends BaseConnectorConfig {
    public static final ConfigDef CONFIG_DEF = JmsSourceConnectorConfig.baseConfigDef();
    public static final String MAX_POLL_CONFIG = "max.poll.records";
    private static final int MAX_POLL_DEFAULT = 100;
    private static final String MAX_POLL_DOC = "The maximum number of JMS messages retrieved during every poll operation.";
    private static final String MAX_POLL_DISPLAY = "Maximum poll records";
    public static final String POLL_TIMEOUT_CONFIG = "poll.timeout.ms";
    private static final long POLL_TIMEOUT_DEFAULT = 1000L;
    private static final String POLL_TIMEOUT_DOC = "Maximum poll timeout for incoming message [ms.].";
    private static final String POLL_TIMEOUT_DISPLAY = "Poll timeout";
    public static final String JMS_SELECTOR_CONFIG = "jms.selector";
    private static final String JMS_SELECTOR_DOC = "JMS message selector.";
    private static final String JMS_SELECTOR_DISPLAY = "Selector";
    public static final String JMS_SUBSCRIPTION_CONFIG = "jms.topic.subscription.name";
    private static final String JMS_SUBSCRIPTION_DOC = "If source connector should poll messages from JSM topic, specify name of subscription.";
    private static final String JMS_SUBSCRIPTION_DISPLAY = "Subscription name";
    public static final String JMS_SUBSCRIPTION_DURABLE_CONFIG = "jms.topic.subscription.durable";
    private static final String JMS_SUBSCRIPTION_DURABLE_DOC = "Positive if user wishes to register durable topic subscription. Default: true.";
    private static final String JMS_SUBSCRIPTION_DURABLE_DISPLAY = "Register durable subscription";
    public static final String JMS_SUBSCRIPTION_SHARED_CONFIG = "jms.topic.subscription.shared";
    private static final String JMS_SUBSCRIPTION_SHARED_DOC = "Positive if user wishes to register shared durable topic subscription (requires JMS 2.0 compliant server). Default: true.";
    private static final String JMS_SUBSCRIPTION_SHARED_DISPLAY = "Register shared durable subscription";

    public JmsSourceConnectorConfig(Map<?, ?> originals) {
        super(CONFIG_DEF, originals);
    }

    private static ConfigDef baseConfigDef() {
        ConfigDef config = new ConfigDef();
        JmsSourceConnectorConfig.addKafkaGroup(config);
        JmsSourceConnectorConfig.addJndiGroup(config);
        JmsSourceConnectorConfig.addCustomJmsGroup(config);
        JmsSourceConnectorConfig.addFormatGroup(config);
        JmsSourceConnectorConfig.addRetryGroup(config);
        return config;
    }

    private static void addCustomJmsGroup(ConfigDef config) {
        int orderInGroup = BaseConnectorConfig.addJmsGroup(config);
        config.define(JMS_SELECTOR_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, JMS_SELECTOR_DOC, "JMS", ++orderInGroup, ConfigDef.Width.LONG, JMS_SELECTOR_DISPLAY);
        config.define(MAX_POLL_CONFIG, ConfigDef.Type.INT, (Object)100, ConfigDef.Importance.LOW, MAX_POLL_DOC, "JMS", ++orderInGroup, ConfigDef.Width.SHORT, MAX_POLL_DISPLAY);
        config.define(POLL_TIMEOUT_CONFIG, ConfigDef.Type.LONG, (Object)1000L, ConfigDef.Importance.LOW, POLL_TIMEOUT_DOC, "JMS", ++orderInGroup, ConfigDef.Width.SHORT, POLL_TIMEOUT_DISPLAY);
        config.define(JMS_SUBSCRIPTION_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, JMS_SUBSCRIPTION_DOC, "JMS", ++orderInGroup, ConfigDef.Width.LONG, JMS_SUBSCRIPTION_DISPLAY);
        config.define(JMS_SUBSCRIPTION_DURABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, JMS_SUBSCRIPTION_DURABLE_DOC, "JMS", ++orderInGroup, ConfigDef.Width.SHORT, JMS_SUBSCRIPTION_DURABLE_DISPLAY);
        config.define(JMS_SUBSCRIPTION_SHARED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, JMS_SUBSCRIPTION_SHARED_DOC, "JMS", ++orderInGroup, ConfigDef.Width.SHORT, JMS_SUBSCRIPTION_SHARED_DISPLAY);
    }
}

