/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.connect.jms.sink;

import io.macronova.kafka.connect.jms.common.BaseConnectorConfig;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class JmsSinkConnectorConfig
extends BaseConnectorConfig {
    public static final ConfigDef CONFIG_DEF = JmsSinkConnectorConfig.baseConfigDef();
    public static final String OUTPUT_FORMAT_CONFIG = "jms.message.converter.output.format";
    public static final String OUTPUT_FORMAT_DEFAULT = "text";
    private static final String OUTPUT_FORMAT_DOC = "Output JMS message format. Options: text | map | object | bytes. Default: text.";
    private static final String OUTPUT_FORMAT_DISPLAY = "Output format";

    public JmsSinkConnectorConfig(Map<?, ?> originals) {
        super(CONFIG_DEF, originals);
    }

    private static ConfigDef baseConfigDef() {
        ConfigDef config = new ConfigDef();
        JmsSinkConnectorConfig.addKafkaGroup(config);
        JmsSinkConnectorConfig.addJndiGroup(config);
        JmsSinkConnectorConfig.addJmsGroup(config);
        JmsSinkConnectorConfig.addCustomFormatGroup(config);
        JmsSinkConnectorConfig.addRetryGroup(config);
        return config;
    }

    private static void addCustomFormatGroup(ConfigDef config) {
        int orderInGroup = BaseConnectorConfig.addFormatGroup(config);
        config.define(OUTPUT_FORMAT_CONFIG, ConfigDef.Type.STRING, (Object)OUTPUT_FORMAT_DEFAULT, ConfigDef.Importance.MEDIUM, OUTPUT_FORMAT_DOC, "Format", ++orderInGroup, ConfigDef.Width.SHORT, OUTPUT_FORMAT_DISPLAY);
    }
}

