/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.connect.jms.domain;

import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class PropertyValue {
    public static final Schema SCHEMA_V1 = SchemaBuilder.struct().name("PropertyValue").version(Integer.valueOf(1)).field("type", Schema.STRING_SCHEMA).field("boolean", Schema.OPTIONAL_BOOLEAN_SCHEMA).field("byte", Schema.OPTIONAL_INT8_SCHEMA).field("short", Schema.OPTIONAL_INT16_SCHEMA).field("integer", Schema.OPTIONAL_INT32_SCHEMA).field("long", Schema.OPTIONAL_INT64_SCHEMA).field("float", Schema.OPTIONAL_FLOAT32_SCHEMA).field("double", Schema.OPTIONAL_FLOAT64_SCHEMA).field("string", Schema.OPTIONAL_STRING_SCHEMA).build();
    private final String type;
    private final Object value;

    public PropertyValue(Object value) {
        this.value = value;
        if (value instanceof Boolean) {
            this.type = "boolean";
        } else if (value instanceof Byte) {
            this.type = "byte";
        } else if (value instanceof Short) {
            this.type = "short";
        } else if (value instanceof Integer) {
            this.type = "integer";
        } else if (value instanceof Long) {
            this.type = "long";
        } else if (value instanceof Float) {
            this.type = "float";
        } else if (value instanceof Double) {
            this.type = "double";
        } else if (value instanceof String) {
            this.type = "string";
        } else {
            throw new UnsupportedOperationException("Unsupported value type: " + value.getClass().getName() + ".");
        }
    }

    public Struct toStructV1() {
        return new Struct(SCHEMA_V1).put("type", (Object)this.type).put(this.type, this.value);
    }
}

