/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.connect.jms.domain;

import io.macronova.kafka.connect.jms.domain.JmsDestination;
import io.macronova.kafka.connect.jms.domain.PropertyValue;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class JmsMessage {
    public static final Schema SCHEMA_V1 = SchemaBuilder.struct().name("JMSMessage").version(Integer.valueOf(1)).field("type", Schema.STRING_SCHEMA).field("messageId", Schema.STRING_SCHEMA).field("correlationId", Schema.OPTIONAL_STRING_SCHEMA).field("destination", JmsDestination.SCHEMA_V1).field("replyTo", JmsDestination.SCHEMA_V1).field("priority", Schema.INT32_SCHEMA).field("expiration", Schema.INT64_SCHEMA).field("timestamp", Schema.INT64_SCHEMA).field("redelivered", Schema.BOOLEAN_SCHEMA).field("properties", (Schema)SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)PropertyValue.SCHEMA_V1).optional()).field("payloadText", Schema.OPTIONAL_STRING_SCHEMA).field("payloadMap", (Schema)SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)PropertyValue.SCHEMA_V1).optional()).field("payloadBytes", Schema.OPTIONAL_BYTES_SCHEMA).build();
    private final String type;
    private final String messageId;
    private final String correlationId;
    private final JmsDestination destination;
    private final JmsDestination replyTo;
    private final int priority;
    private final long expiration;
    private final long timestamp;
    private final boolean redelivered;
    private final Map<String, Struct> properties;
    private final String payloadText;
    private final Map<String, Struct> payloadMap;
    private final byte[] payloadBytes;

    public JmsMessage(Message jms) throws JMSException {
        this.messageId = jms.getJMSMessageID();
        this.correlationId = jms.getJMSCorrelationID();
        this.destination = jms.getJMSDestination() != null ? new JmsDestination(jms.getJMSDestination()) : null;
        this.replyTo = jms.getJMSReplyTo() != null ? new JmsDestination(jms.getJMSReplyTo()) : null;
        this.priority = jms.getJMSPriority();
        this.expiration = jms.getJMSExpiration();
        this.timestamp = jms.getJMSTimestamp();
        this.redelivered = jms.getJMSRedelivered();
        this.properties = JmsMessage.propertiesMap(jms);
        if (jms instanceof TextMessage) {
            this.type = "text";
            this.payloadText = ((TextMessage)jms).getText();
            this.payloadMap = null;
            this.payloadBytes = null;
        } else if (jms instanceof MapMessage) {
            this.type = "map";
            MapMessage mapMessage = (MapMessage)jms;
            HashMap<String, Struct> map = new HashMap<String, Struct>();
            Enumeration names = mapMessage.getMapNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                map.put(name, new PropertyValue(mapMessage.getObject(name)).toStructV1());
            }
            this.payloadText = null;
            this.payloadMap = map;
            this.payloadBytes = null;
        } else if (jms instanceof BytesMessage) {
            this.type = "bytes";
            BytesMessage bytesMessage = (BytesMessage)jms;
            byte[] bytes = new byte[(int)bytesMessage.getBodyLength()];
            bytesMessage.reset();
            bytesMessage.readBytes(bytes);
            this.payloadText = null;
            this.payloadMap = null;
            this.payloadBytes = bytes;
        } else {
            throw new UnsupportedOperationException("JMS message type '" + jms.getClass() + "' is not supported.");
        }
    }

    private static Map<String, Struct> propertiesMap(Message jms) throws JMSException {
        HashMap<String, Struct> result = new HashMap<String, Struct>();
        Enumeration names = jms.getPropertyNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            result.put(name, new PropertyValue(jms.getObjectProperty(name)).toStructV1());
        }
        return result;
    }

    public Struct toStructV1() {
        Struct result = new Struct(SCHEMA_V1).put("type", (Object)this.type).put("messageId", (Object)this.messageId).put("correlationId", (Object)this.correlationId).put("priority", (Object)this.priority).put("expiration", (Object)this.expiration).put("timestamp", (Object)this.timestamp).put("redelivered", (Object)this.redelivered).put("properties", this.properties);
        if (this.payloadText != null) {
            result.put("payloadText", (Object)this.payloadText);
        }
        if (this.payloadMap != null) {
            result.put("payloadMap", this.payloadMap);
        }
        if (this.payloadBytes != null) {
            result.put("payloadBytes", (Object)this.payloadBytes);
        }
        if (this.destination != null) {
            result.put("destination", (Object)this.destination.toStructV1());
        }
        if (this.replyTo != null) {
            result.put("replyTo", (Object)this.replyTo.toStructV1());
        }
        return result;
    }
}

