/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.connect.jms.domain;

import io.macronova.kafka.connect.jms.util.JmsUtils;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class JmsDestination {
    public static final Schema SCHEMA_V1 = SchemaBuilder.struct().name("JMSDestination").version(Integer.valueOf(1)).field("type", Schema.STRING_SCHEMA).field("name", Schema.STRING_SCHEMA).optional().build();
    private final String type;
    private final String name;

    public JmsDestination(Destination destination) throws JMSException {
        this.type = JmsUtils.destinationType(destination);
        this.name = JmsUtils.destinationName(destination);
    }

    public Struct toStructV1() {
        return new Struct(SCHEMA_V1).put("type", (Object)this.type).put("name", (Object)this.name);
    }
}

