/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.connect.jms.common;

import io.confluent.connect.avro.AvroConverter;
import io.macronova.kafka.connect.jms.common.JmsConverter;
import io.macronova.kafka.connect.jms.domain.JmsMessage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.storage.Converter;

public class StandardJmsConverter
implements JmsConverter {
    private Map<String, String> configuration = null;
    private OutputFormat outputFormat = null;
    private Converter jsonConverter = null;
    private Converter avroConverter = null;

    @Override
    public void configure(Map<String, String> properties) {
        this.configuration = new HashMap<String, String>(properties);
        this.outputFormat = OutputFormat.valueOf(properties.getOrDefault("jms.message.converter.output.format", "text").toUpperCase());
    }

    @Override
    public Message recordToMessage(Session session, SinkRecord record) throws JMSException {
        Message message = null;
        switch (this.outputFormat) {
            case TEXT: {
                message = this.createTextMessage(session, record);
                break;
            }
            case JSON: {
                message = this.createJsonMessage(session, record);
                break;
            }
            case MAP: {
                message = this.createMapMessage(session, record);
                break;
            }
            case OBJECT: {
                message = this.createObjectMessage(session, record);
                break;
            }
            case BYTES: {
                message = this.createBytesMessage(session, record);
                break;
            }
            case AVRO: {
                message = this.createAvroMessage(session, record);
            }
        }
        if (message == null) {
            throw new UnsupportedOperationException("Unsupported output format: " + (Object)((Object)this.outputFormat) + ".");
        }
        this.addCommonProperties(message, record);
        return message;
    }

    private Message createTextMessage(Session session, SinkRecord record) throws JMSException {
        String value = record.value() != null ? record.value().toString() : "";
        return session.createTextMessage(value);
    }

    private Message createJsonMessage(Session session, SinkRecord record) throws JMSException {
        byte[] serialized = this.lazyJsonConverter().fromConnectData(record.topic(), record.valueSchema(), record.value());
        return session.createTextMessage(new String(serialized));
    }

    private Message createMapMessage(Session session, SinkRecord record) throws JMSException {
        MapMessage message = session.createMapMessage();
        if (record.valueSchema() != null && Schema.Type.STRUCT.equals((Object)record.valueSchema().type())) {
            Struct value = (Struct)record.value();
            for (Field field : value.schema().fields()) {
                this.mapField(field.name(), value.get(field), field.schema(), session, message);
            }
        } else if (record.valueSchema() != null) {
            this.mapField("payload", record.value(), record.valueSchema(), session, message);
        } else {
            message.setObject("payload", record.value());
        }
        return message;
    }

    private Message createObjectMessage(Session session, SinkRecord record) throws JMSException {
        ObjectMessage message = session.createObjectMessage();
        message.setObject((Serializable)record.value());
        return message;
    }

    private Message createBytesMessage(Session session, SinkRecord record) throws JMSException {
        BytesMessage message = session.createBytesMessage();
        message.writeBytes((byte[])record.value());
        return message;
    }

    private Message createAvroMessage(Session session, SinkRecord record) throws JMSException {
        BytesMessage message = session.createBytesMessage();
        message.writeBytes(this.lazyAvroConverter().fromConnectData(record.topic(), record.valueSchema(), record.value()));
        return message;
    }

    private void mapField(String name, Object value, Schema schema, Session session, MapMessage message) throws JMSException {
        switch (schema.type()) {
            case BYTES: {
                message.setBytes(name, (byte[])value);
                break;
            }
            case BOOLEAN: {
                message.setBoolean(name, ((Boolean)value).booleanValue());
                break;
            }
            case FLOAT32: {
                message.setFloat(name, ((Float)value).floatValue());
                break;
            }
            case FLOAT64: {
                message.setDouble(name, ((Double)value).doubleValue());
                break;
            }
            case INT8: {
                message.setByte(name, ((Byte)value).byteValue());
                break;
            }
            case INT16: {
                message.setShort(name, ((Short)value).shortValue());
                break;
            }
            case INT32: {
                message.setInt(name, ((Integer)value).intValue());
                break;
            }
            case INT64: {
                message.setLong(name, ((Long)value).longValue());
                break;
            }
            case STRING: {
                message.setString(name, (String)value);
                break;
            }
            case MAP: 
            case ARRAY: {
                message.setObject(name, value);
                break;
            }
            case STRUCT: {
                MapMessage nestedMessage = session.createMapMessage();
                Struct struct = (Struct)value;
                for (Field field : struct.schema().fields()) {
                    this.mapField(field.name(), struct.get(field), field.schema(), session, nestedMessage);
                }
                message.setObject(name, (Object)nestedMessage);
            }
        }
    }

    private void addCommonProperties(Message message, SinkRecord record) throws JMSException {
        Object key = record.key();
        if (key instanceof Byte) {
            message.setByteProperty("KafkaKey", ((Byte)key).byteValue());
        } else if (key instanceof Short) {
            message.setShortProperty("KafkaKey", ((Short)key).shortValue());
        } else if (key instanceof Integer) {
            message.setIntProperty("KafkaKey", ((Integer)key).intValue());
        } else if (key instanceof Long) {
            message.setLongProperty("KafkaKey", ((Long)key).longValue());
        } else if (key instanceof Float) {
            message.setFloatProperty("KafkaKey", ((Float)key).floatValue());
        } else if (key instanceof Double) {
            message.setDoubleProperty("KafkaKey", ((Double)key).doubleValue());
        } else if (key instanceof Boolean) {
            message.setBooleanProperty("KafkaKey", ((Boolean)key).booleanValue());
        } else if (key != null) {
            message.setStringProperty("KafkaKey", key.toString());
        }
        message.setStringProperty("KafkaTopic", record.topic());
        message.setIntProperty("KafkaPartition", record.kafkaPartition().intValue());
        message.setLongProperty("KafkaOffset", record.kafkaOffset());
        if (!TimestampType.NO_TIMESTAMP_TYPE.equals((Object)record.timestampType())) {
            message.setLongProperty("KafkaTimestamp", record.timestamp().longValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Converter lazyJsonConverter() {
        if (this.jsonConverter == null) {
            StandardJmsConverter standardJmsConverter = this;
            synchronized (standardJmsConverter) {
                if (this.jsonConverter == null) {
                    JsonConverter converter = new JsonConverter();
                    HashMap<String, String> copy = new HashMap<String, String>(this.configuration);
                    copy.put("converter.type", "value");
                    converter.configure(copy);
                    this.jsonConverter = converter;
                }
            }
        }
        return this.jsonConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Converter lazyAvroConverter() {
        if (this.avroConverter == null) {
            StandardJmsConverter standardJmsConverter = this;
            synchronized (standardJmsConverter) {
                if (this.avroConverter == null) {
                    AvroConverter converter = new AvroConverter();
                    HashMap<String, String> copy = new HashMap<String, String>(this.configuration);
                    converter.configure(copy, false);
                    this.avroConverter = converter;
                }
            }
        }
        return this.avroConverter;
    }

    @Override
    public SourceRecord messageToRecord(Message message, String topic, Map<String, ?> sourcePartition, Map<String, ?> sourceOffset) throws JMSException {
        return new SourceRecord(sourcePartition, sourceOffset, topic, Schema.STRING_SCHEMA, (Object)message.getJMSMessageID(), JmsMessage.SCHEMA_V1, (Object)new JmsMessage(message).toStructV1());
    }

    public static enum OutputFormat {
        TEXT,
        MAP,
        OBJECT,
        BYTES,
        JSON,
        AVRO;

    }
}

