/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.connect.jms.common;

import io.macronova.kafka.connect.jms.common.JmsDialect;
import io.macronova.kafka.connect.jms.util.StringUtils;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.apache.kafka.connect.errors.ConnectException;

public class JmsSessionProvider {
    private final Map<String, String> config;
    private final JmsDialect dialect;
    private InitialContext context;
    private Connection connection;
    private final AtomicBoolean reconnectionGuard = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public JmsSessionProvider(Map<String, String> properties) throws ConnectException {
        try {
            this.config = properties;
            String dialectClass = properties.get("jms.dialect.class");
            this.dialect = (JmsDialect)Class.forName(dialectClass).newInstance();
            this.connect(properties);
        }
        catch (Exception e) {
            throw new ConnectException("Failed to establish JMS connectivity: " + e.getMessage() + ".", (Throwable)e);
        }
    }

    private void connect(Map<String, String> properties) throws ConnectException {
        try {
            ConnectionFactory factory = null;
            if (!StringUtils.isEmpty(properties.get("java.naming.factory.initial"))) {
                String extraParams;
                String password;
                Properties contextConfig = new Properties();
                contextConfig.put("java.naming.factory.initial", properties.get("java.naming.factory.initial"));
                contextConfig.put("java.naming.provider.url", properties.get("java.naming.provider.url"));
                String user = properties.get("java.naming.security.principal");
                if (!StringUtils.isEmpty(user)) {
                    contextConfig.put("java.naming.security.principal", user);
                }
                if (!StringUtils.isEmpty(password = properties.get("java.naming.security.credentials"))) {
                    contextConfig.put("java.naming.security.credentials", password);
                }
                if ((extraParams = properties.get("jndi.extra.params")) != null) {
                    for (String param : extraParams.split(",")) {
                        String[] kv = param.split("=");
                        contextConfig.put(kv[0].trim(), kv[1].trim());
                    }
                }
                this.context = new InitialContext(contextConfig);
                factory = (ConnectionFactory)this.context.lookup(properties.get("jndi.connection.factory"));
            } else {
                this.context = null;
                factory = this.dialect.createConnectionFactory(properties);
            }
            String user = properties.get("jms.username");
            this.connection = !StringUtils.isEmpty(user) ? factory.createConnection(user, properties.get("jms.password")) : factory.createConnection();
            String clientId = properties.get("jms.client.id");
            if (!StringUtils.isEmpty(clientId)) {
                this.connection.setClientID(clientId);
            }
            this.connection.start();
            this.connection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException exception) {
                    JmsSessionProvider.this.closed.set(true);
                }
            });
            this.closed.set(false);
        }
        catch (Exception e) {
            throw new ConnectException("Failed to establish JMS connectivity: " + e.getMessage() + ".", (Throwable)e);
        }
    }

    public boolean reconnect() {
        if (this.closed.get() && this.reconnectionGuard.compareAndSet(false, true)) {
            try {
                this.closeQuietly();
                this.connect(this.config);
                boolean bl = true;
                return bl;
            }
            finally {
                this.reconnectionGuard.set(false);
            }
        }
        return !this.closed.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public JmsDialect getDialect() {
        return this.dialect;
    }

    public Session createSession(boolean transacted) throws JMSException {
        return this.connection.createSession(transacted, 2);
    }

    public Destination resolveDestination(Session session, String destination, String type) throws Exception {
        if (this.context != null) {
            return (Destination)this.context.lookup(destination);
        }
        if ("topic".equals(type)) {
            return session.createTopic(destination);
        }
        return session.createQueue(destination);
    }

    public void closeQuietly() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.closed.set(true);
    }
}

