/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.connect.jms.common;

import io.macronova.kafka.connect.jms.common.BaseConnectorConfig;
import io.macronova.kafka.connect.jms.common.JmsSessionProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JmsConnectionPool {
    private static final Logger log = LoggerFactory.getLogger(JmsConnectionPool.class);
    private static final Map<Map<String, String>, AtomicInteger> usageCount = new HashMap<Map<String, String>, AtomicInteger>();
    private static final Map<Map<String, String>, JmsSessionProvider> pool = new HashMap<Map<String, String>, JmsSessionProvider>();

    public static synchronized JmsSessionProvider getOrCreateConnection(Map<String, String> key) throws Exception {
        Map<String, String> connectionKey = JmsConnectionPool.toConnectionKey(key);
        JmsSessionProvider provider = pool.get(connectionKey);
        if (provider == null) {
            log.info("Opening new JMS connection to server: " + BaseConnectorConfig.getBrokerUrl(connectionKey) + ".");
            provider = new JmsSessionProvider(connectionKey);
            usageCount.put(connectionKey, new AtomicInteger(1));
            pool.put(connectionKey, provider);
        } else {
            usageCount.get(connectionKey).incrementAndGet();
        }
        return provider;
    }

    public static synchronized void destroyConnection(Map<String, String> key) {
        Map<String, String> connectionKey = JmsConnectionPool.toConnectionKey(key);
        AtomicInteger count = usageCount.get(connectionKey);
        if (count != null) {
            int usage = count.decrementAndGet();
            if (usage == 0) {
                log.info("Closing JMS connection to server: " + BaseConnectorConfig.getBrokerUrl(connectionKey) + ".");
                usageCount.remove(connectionKey);
                pool.remove(connectionKey).closeQuietly();
            } else {
                usageCount.get(connectionKey).set(usage);
            }
        }
    }

    private static Map<String, String> toConnectionKey(Map<String, String> config) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("java.naming.factory.initial", config.get("java.naming.factory.initial"));
        key.put("java.naming.provider.url", config.get("java.naming.provider.url"));
        key.put("java.naming.security.principal", config.get("java.naming.security.principal"));
        key.put("java.naming.security.credentials", config.get("java.naming.security.credentials"));
        key.put("jndi.extra.params", config.get("jndi.extra.params"));
        key.put("jndi.connection.factory", config.get("jndi.connection.factory"));
        key.put("jms.connection.factory", config.get("jms.connection.factory"));
        key.put("jms.url", config.get("jms.url"));
        key.put("jms.username", config.get("jms.username"));
        key.put("jms.password", config.get("jms.password"));
        key.put("jms.client.id", config.get("jms.client.id"));
        key.put("jms.dialect.class", config.getOrDefault("jms.dialect.class", BaseConnectorConfig.JMS_DIALECT_DEFAULT));
        for (Map.Entry<String, String> param : config.entrySet()) {
            if (!param.getKey().startsWith("jms.dialect.")) continue;
            key.put(param.getKey(), param.getValue());
        }
        return key;
    }
}

