/*
 * Decompiled with CFR 0.152.
 */
package io.macronova.kafka.connect.jms;

import io.macronova.kafka.connect.jms.sink.JmsSinkConnectorConfig;
import io.macronova.kafka.connect.jms.sink.JmsSinkTask;
import io.macronova.kafka.connect.jms.util.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsSinkConnector
extends SinkConnector {
    private static final Logger log = LoggerFactory.getLogger(JmsSinkConnector.class);
    private Map<String, String> configProperties = null;
    private JmsSinkConnectorConfig config = null;

    public String version() {
        return Version.getVersion();
    }

    public void start(Map<String, String> properties) {
        log.info("Starting JMS sink connector version " + this.version() + ".");
        try {
            this.configProperties = properties;
            this.config = new JmsSinkConnectorConfig(this.configProperties);
        }
        catch (ConfigException e) {
            throw new ConnectException("Failed to start JMS sink connector due to configuration error: " + e.getMessage() + ".", (Throwable)e);
        }
    }

    public Class<? extends Task> taskClass() {
        return JmsSinkTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>(maxTasks);
        for (int i = 0; i < maxTasks; ++i) {
            configs.add(this.configProperties);
        }
        return configs;
    }

    public void stop() {
    }

    public ConfigDef config() {
        return JmsSinkConnectorConfig.CONFIG_DEF;
    }
}

