package io.loop.fusion.api;

/**
 * An interface defining a behavior for {@link FusionModule}s that have the possibility
 * to actually "match" to value.
 *
 * @see {@link FusionEvent}
 * @see {@link FusionState}
 *
 * @author Alexandre Piveteau
 */
/* package */ interface FusionMatcher<T> {

    /**
     * @param value A {@link T} corresponding to the first value.
     * @param savedValue A {@link T} corresponding to the second (saved) value.
     * @return True if both value match, false otherwise.
     */
    // TODO : Document this better.
    boolean match(T value, T savedValue);
}
