/*
 * Decompiled with CFR 0.152.
 */
package io.logpush.logback.appender;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import com.google.gson.Gson;
import java.io.OutputStream;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogpushAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final MediaType CONTENT_TYPE = MediaType.parse((String)"application/json;charset=utf-8");
    private static final boolean DEFAULT_ONLY_ERROR = true;
    private static final Gson GSON = new Gson();
    private String token;
    private boolean onlyError = true;
    private LayoutWrappingEncoder<ILoggingEvent> encoder;
    private OkHttpClient client;

    public void start() {
        if (!this.checkProperty()) {
            this.addError("No set token [" + this.name + "].");
            return;
        }
        if (this.encoder == null) {
            this.addError("No encoder set for the appender named [" + this.name + "].");
            return;
        }
        try {
            this.encoder.init((OutputStream)System.out);
            this.client = new OkHttpClient();
        }
        catch (Exception e) {
            this.addError("Exception", e);
        }
        super.start();
    }

    private boolean checkProperty() {
        return this.token != null && this.token.length() != 0;
    }

    protected void append(ILoggingEvent event) {
        if (event.getLevel() != Level.ERROR && this.onlyError) {
            return;
        }
        this.sendToLogpush(event);
    }

    private void sendToLogpush(ILoggingEvent event) {
        String msg = this.encoder.getLayout().doLayout((Object)event);
        LogpushBody logpushBody = new LogpushBody();
        logpushBody.message = msg;
        logpushBody.level = event.getLevel().toString();
        RequestBody body = RequestBody.create((MediaType)CONTENT_TYPE, (String)GSON.toJson((Object)logpushBody, LogpushBody.class));
        Request req = new Request.Builder().url("http://logpush.io/api/v1/logs?app_token=" + this.token).post(body).build();
        try {
            this.client.newCall(req).execute();
        }
        catch (Exception e) {
            this.addError("Exception", e);
        }
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean isOnlyError() {
        return this.onlyError;
    }

    public void setOnlyError(boolean onlyError) {
        this.onlyError = onlyError;
    }

    public LayoutWrappingEncoder<ILoggingEvent> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(LayoutWrappingEncoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    private class LogpushBody {
        private String level;
        private String message;

        private LogpushBody() {
        }
    }
}

