package io.logicdrop.openapi.webmvc.api;

import io.logicdrop.openapi.webmvc.ApiClient;

import io.logicdrop.openapi.models.OperationRequest;
import io.logicdrop.openapi.models.OperationResponse;
import io.logicdrop.openapi.models.OperationTargetResponse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;


@Component("io.logicdrop.openapi.webmvc.api.PlatformServicesApi")
public class PlatformServicesApi {
    private ApiClient apiClient;

    public PlatformServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public PlatformServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * List managed services
     * Get manges targets
     * <p><b>200</b> - Retrieved targets
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param service Service (required)
     * @param operationRequest Operation request (required)
     * @param data Include data (optional)
     * @return List&lt;OperationTargetResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<OperationTargetResponse> listManagedServices(String service, OperationRequest operationRequest, String data) throws RestClientException {
        return listManagedServicesWithHttpInfo(service, operationRequest, data).getBody();
    }

    /**
     * List managed services
     * Get manges targets
     * <p><b>200</b> - Retrieved targets
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param service Service (required)
     * @param operationRequest Operation request (required)
     * @param data Include data (optional)
     * @return ResponseEntity&lt;List&lt;OperationTargetResponse&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<OperationTargetResponse>> listManagedServicesWithHttpInfo(String service, OperationRequest operationRequest, String data) throws RestClientException {
        Object postBody = operationRequest;
        
        // verify the required parameter 'service' is set
        if (service == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'service' when calling listManagedServices");
        }
        
        // verify the required parameter 'operationRequest' is set
        if (operationRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'operationRequest' when calling listManagedServices");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("service", service);
        String path = apiClient.expandPath("/manage/{service}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "data", data));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<OperationTargetResponse>> returnType = new ParameterizedTypeReference<List<OperationTargetResponse>>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Manage service
     * Perform managed operation
     * <p><b>200</b> - Operations response
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param service Service (required)
     * @param operationRequest Operation request (required)
     * @return OperationResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public OperationResponse manageService(String service, OperationRequest operationRequest) throws RestClientException {
        return manageServiceWithHttpInfo(service, operationRequest).getBody();
    }

    /**
     * Manage service
     * Perform managed operation
     * <p><b>200</b> - Operations response
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param service Service (required)
     * @param operationRequest Operation request (required)
     * @return ResponseEntity&lt;OperationResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<OperationResponse> manageServiceWithHttpInfo(String service, OperationRequest operationRequest) throws RestClientException {
        Object postBody = operationRequest;
        
        // verify the required parameter 'service' is set
        if (service == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'service' when calling manageService");
        }
        
        // verify the required parameter 'operationRequest' is set
        if (operationRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'operationRequest' when calling manageService");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("service", service);
        String path = apiClient.expandPath("/manage/{service}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<OperationResponse> returnType = new ParameterizedTypeReference<OperationResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Platform details
     * Retrieve information
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad request
     * <p><b>500</b> - Backend Error
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void platformInfo() throws RestClientException {
        platformInfoWithHttpInfo();
    }

    /**
     * Platform details
     * Retrieve information
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad request
     * <p><b>500</b> - Backend Error
     * @return ResponseEntity&lt;Void&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Void> platformInfoWithHttpInfo() throws RestClientException {
        Object postBody = null;
        
        String path = apiClient.expandPath("/info", Collections.<String, Object>emptyMap());

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<Void> returnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
}
