package io.logicdrop.openapi.webmvc.api;

import io.logicdrop.openapi.webmvc.ApiClient;

import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.Bundle;
import java.io.File;
import io.logicdrop.openapi.models.ScaffoldRequest;
import io.logicdrop.openapi.models.ScaffoldResponse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;


@Component("io.logicdrop.openapi.webmvc.api.PackageServicesApi")
public class PackageServicesApi {
    private ApiClient apiClient;

    public PackageServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public PackageServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Delete package
     * Delete package
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param _package Package name (required)
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ArtifactResponse deletePackage(String client, String _package) throws RestClientException {
        return deletePackageWithHttpInfo(client, _package).getBody();
    }

    /**
     * Delete package
     * Delete package
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param _package Package name (required)
     * @return ResponseEntity&lt;ArtifactResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ArtifactResponse> deletePackageWithHttpInfo(String client, String _package) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deletePackage");
        }
        
        // verify the required parameter '_package' is set
        if (_package == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter '_package' when calling deletePackage");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("package", _package);
        String path = apiClient.expandPath("/packages/{client}/{package}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> returnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.DELETE, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Get package
     * Get package
     * <p><b>200</b> - The package
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param _package Package name (required)
     * @return Bundle
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Bundle getPackage(String client, String _package) throws RestClientException {
        return getPackageWithHttpInfo(client, _package).getBody();
    }

    /**
     * Get package
     * Get package
     * <p><b>200</b> - The package
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param _package Package name (required)
     * @return ResponseEntity&lt;Bundle&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Bundle> getPackageWithHttpInfo(String client, String _package) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getPackage");
        }
        
        // verify the required parameter '_package' is set
        if (_package == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter '_package' when calling getPackage");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("package", _package);
        String path = apiClient.expandPath("/packages/{client}/{package}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<Bundle> returnType = new ParameterizedTypeReference<Bundle>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * List packages
     * Get packages
     * <p><b>200</b> - Retrieved packages
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @return List&lt;Bundle&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<Bundle> listPackages(String client) throws RestClientException {
        return listPackagesWithHttpInfo(client).getBody();
    }

    /**
     * List packages
     * Get packages
     * <p><b>200</b> - Retrieved packages
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @return ResponseEntity&lt;List&lt;Bundle&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<Bundle>> listPackagesWithHttpInfo(String client) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listPackages");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        String path = apiClient.expandPath("/packages/{client}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<Bundle>> returnType = new ParameterizedTypeReference<List<Bundle>>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Scaffold project
     * Scaffold project
     * <p><b>200</b> - Scaffold response
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param scaffoldRequest Scaffold request (required)
     * @return ScaffoldResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ScaffoldResponse scaffoldProject(String client, ScaffoldRequest scaffoldRequest) throws RestClientException {
        return scaffoldProjectWithHttpInfo(client, scaffoldRequest).getBody();
    }

    /**
     * Scaffold project
     * Scaffold project
     * <p><b>200</b> - Scaffold response
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param scaffoldRequest Scaffold request (required)
     * @return ResponseEntity&lt;ScaffoldResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ScaffoldResponse> scaffoldProjectWithHttpInfo(String client, ScaffoldRequest scaffoldRequest) throws RestClientException {
        Object postBody = scaffoldRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling scaffoldProject");
        }
        
        // verify the required parameter 'scaffoldRequest' is set
        if (scaffoldRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'scaffoldRequest' when calling scaffoldProject");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        String path = apiClient.expandPath("/packages/{client}/scaffold", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ScaffoldResponse> returnType = new ParameterizedTypeReference<ScaffoldResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Upload packages
     * Upload packages(s)
     * <p><b>200</b> - The uploaded files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param file File (optional)
     * @return List&lt;Bundle&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<Bundle> uploadPackage(String client, File file) throws RestClientException {
        return uploadPackageWithHttpInfo(client, file).getBody();
    }

    /**
     * Upload packages
     * Upload packages(s)
     * <p><b>200</b> - The uploaded files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param file File (optional)
     * @return ResponseEntity&lt;List&lt;Bundle&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<Bundle>> uploadPackageWithHttpInfo(String client, File file) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling uploadPackage");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        String path = apiClient.expandPath("/packages/{client}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        if (file != null)
            formParams.add("file", new FileSystemResource(file));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "multipart/form-data"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<Bundle>> returnType = new ParameterizedTypeReference<List<Bundle>>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Upload scaffold
     * Upload a scaffold project
     * <p><b>200</b> - Scaffold response
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param file File (optional)
     * @return ScaffoldResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ScaffoldResponse uploadScaffold(String client, File file) throws RestClientException {
        return uploadScaffoldWithHttpInfo(client, file).getBody();
    }

    /**
     * Upload scaffold
     * Upload a scaffold project
     * <p><b>200</b> - Scaffold response
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param file File (optional)
     * @return ResponseEntity&lt;ScaffoldResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ScaffoldResponse> uploadScaffoldWithHttpInfo(String client, File file) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling uploadScaffold");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        String path = apiClient.expandPath("/packages/{client}/scaffold/upload", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        if (file != null)
            formParams.add("file", new FileSystemResource(file));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "multipart/form-data"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ScaffoldResponse> returnType = new ParameterizedTypeReference<ScaffoldResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
}
