package io.logicdrop.openapi.webmvc.api;

import io.logicdrop.openapi.webmvc.ApiClient;

import io.logicdrop.openapi.models.EmailMessage;
import io.logicdrop.openapi.models.EmailResult;
import io.logicdrop.openapi.models.EmailWithAttachment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;


@Component("io.logicdrop.openapi.webmvc.api.EmailServicesApi")
public class EmailServicesApi {
    private ApiClient apiClient;

    public EmailServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public EmailServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Send email
     * Send an email
     * <p><b>200</b> - Email result
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param emailMessage Email payload (required)
     * @return EmailResult
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public EmailResult sendEmail(String client, EmailMessage emailMessage) throws RestClientException {
        return sendEmailWithHttpInfo(client, emailMessage).getBody();
    }

    /**
     * Send email
     * Send an email
     * <p><b>200</b> - Email result
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param emailMessage Email payload (required)
     * @return ResponseEntity&lt;EmailResult&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<EmailResult> sendEmailWithHttpInfo(String client, EmailMessage emailMessage) throws RestClientException {
        Object postBody = emailMessage;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling sendEmail");
        }
        
        // verify the required parameter 'emailMessage' is set
        if (emailMessage == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'emailMessage' when calling sendEmail");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        String path = apiClient.expandPath("/email/{client}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<EmailResult> returnType = new ParameterizedTypeReference<EmailResult>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Send email with attachments
     * Send an email with an attachment
     * <p><b>200</b> - Email result
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param emailWithAttachment Email with attachment (required)
     * @return EmailResult
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public EmailResult sendWithAttachment(String client, EmailWithAttachment emailWithAttachment) throws RestClientException {
        return sendWithAttachmentWithHttpInfo(client, emailWithAttachment).getBody();
    }

    /**
     * Send email with attachments
     * Send an email with an attachment
     * <p><b>200</b> - Email result
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param emailWithAttachment Email with attachment (required)
     * @return ResponseEntity&lt;EmailResult&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<EmailResult> sendWithAttachmentWithHttpInfo(String client, EmailWithAttachment emailWithAttachment) throws RestClientException {
        Object postBody = emailWithAttachment;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling sendWithAttachment");
        }
        
        // verify the required parameter 'emailWithAttachment' is set
        if (emailWithAttachment == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'emailWithAttachment' when calling sendWithAttachment");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        String path = apiClient.expandPath("/email/{client}/send", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<EmailResult> returnType = new ParameterizedTypeReference<EmailResult>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
}
