package io.logicdrop.openapi.webmvc.api;

import io.logicdrop.openapi.webmvc.ApiClient;

import io.logicdrop.openapi.models.ActivateRulesetResponse;
import io.logicdrop.openapi.models.AnalyzerRequest;
import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.ComputePipelineRequest;
import io.logicdrop.openapi.models.ComputePipelineResponse;
import io.logicdrop.openapi.models.ComputeRule;
import io.logicdrop.openapi.models.ComputeRuleset;
import io.logicdrop.openapi.models.ContainerResponse;
import io.logicdrop.openapi.models.DataResponse;
import io.logicdrop.openapi.models.DeleteArtifactRequest;
import io.logicdrop.openapi.models.DeleteDataRequest;
import io.logicdrop.openapi.models.DesignerResult;
import java.io.File;
import io.logicdrop.openapi.models.GenerateAllRequest;
import io.logicdrop.openapi.models.GenerateOneRequest;
import io.logicdrop.openapi.models.ProcessorRequest;
import io.logicdrop.openapi.models.ProcessorResult;
import io.logicdrop.openapi.models.RuleContainer;
import io.logicdrop.openapi.models.SamplerRequest;
import io.logicdrop.openapi.models.UpdateArtifactRequest;
import io.logicdrop.openapi.models.UpdateRuleTypesRequest;
import io.logicdrop.openapi.models.UpdateRulesetResponse;
import io.logicdrop.openapi.models.UploadResponse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;


@Component("io.logicdrop.openapi.webmvc.api.ComputeServicesApi")
public class ComputeServicesApi {
    private ApiClient apiClient;

    public ComputeServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public ComputeServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate ruleset
     * Activate a ruleset
     * <p><b>200</b> - Ruleset state
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @return ActivateRulesetResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ActivateRulesetResponse activateRuleset(String client, String project, String artifact, String v) throws RestClientException {
        return activateRulesetWithHttpInfo(client, project, artifact, v).getBody();
    }

    /**
     * Activate ruleset
     * Activate a ruleset
     * <p><b>200</b> - Ruleset state
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @return ResponseEntity&lt;ActivateRulesetResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ActivateRulesetResponse> activateRulesetWithHttpInfo(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling activateRuleset");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling activateRuleset");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling activateRuleset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/activate", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ActivateRulesetResponse> returnType = new ParameterizedTypeReference<ActivateRulesetResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Analyze ruleset
     * Analyze ruleset
     * <p><b>200</b> - Analysis results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * <p><b>503</b> - Container unavailable
     * @param client Client (required)
     * @param analyzerRequest Analysis execute request (required)
     * @return DesignerResult
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DesignerResult analyzeRuleset(String client, AnalyzerRequest analyzerRequest) throws RestClientException {
        return analyzeRulesetWithHttpInfo(client, analyzerRequest).getBody();
    }

    /**
     * Analyze ruleset
     * Analyze ruleset
     * <p><b>200</b> - Analysis results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * <p><b>503</b> - Container unavailable
     * @param client Client (required)
     * @param analyzerRequest Analysis execute request (required)
     * @return ResponseEntity&lt;DesignerResult&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DesignerResult> analyzeRulesetWithHttpInfo(String client, AnalyzerRequest analyzerRequest) throws RestClientException {
        Object postBody = analyzerRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling analyzeRuleset");
        }
        
        // verify the required parameter 'analyzerRequest' is set
        if (analyzerRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'analyzerRequest' when calling analyzeRuleset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        String path = apiClient.expandPath("/compute/{client}/analyze", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<DesignerResult> returnType = new ParameterizedTypeReference<DesignerResult>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Deactivate ruleset
     * Deactivate a ruleset
     * <p><b>200</b> - Ruleset state
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @return ActivateRulesetResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ActivateRulesetResponse deactivateRuleset(String client, String project, String artifact, String v) throws RestClientException {
        return deactivateRulesetWithHttpInfo(client, project, artifact, v).getBody();
    }

    /**
     * Deactivate ruleset
     * Deactivate a ruleset
     * <p><b>200</b> - Ruleset state
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @return ResponseEntity&lt;ActivateRulesetResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ActivateRulesetResponse> deactivateRulesetWithHttpInfo(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deactivateRuleset");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deactivateRuleset");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling deactivateRuleset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/activate", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ActivateRulesetResponse> returnType = new ParameterizedTypeReference<ActivateRulesetResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.DELETE, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Delete rule
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param id Rule Id (required)
     * @param v Ruleset version (optional)
     * @return DataResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DataResponse deleteRule(String client, String project, String artifact, String id, String v) throws RestClientException {
        return deleteRuleWithHttpInfo(client, project, artifact, id, v).getBody();
    }

    /**
     * Delete rule
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param id Rule Id (required)
     * @param v Ruleset version (optional)
     * @return ResponseEntity&lt;DataResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DataResponse> deleteRuleWithHttpInfo(String client, String project, String artifact, String id, String v) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteRule");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deleteRule");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling deleteRule");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling deleteRule");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        uriVariables.put("id", id);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/rules/{id}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<DataResponse> returnType = new ParameterizedTypeReference<DataResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.DELETE, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Delete rules
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param deleteDataRequest Remove rules by criteria (required)
     * @param v Ruleset version (optional)
     * @return DataResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DataResponse deleteRules(String client, String project, String artifact, DeleteDataRequest deleteDataRequest, String v) throws RestClientException {
        return deleteRulesWithHttpInfo(client, project, artifact, deleteDataRequest, v).getBody();
    }

    /**
     * Delete rules
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param deleteDataRequest Remove rules by criteria (required)
     * @param v Ruleset version (optional)
     * @return ResponseEntity&lt;DataResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DataResponse> deleteRulesWithHttpInfo(String client, String project, String artifact, DeleteDataRequest deleteDataRequest, String v) throws RestClientException {
        Object postBody = deleteDataRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteRules");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deleteRules");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling deleteRules");
        }
        
        // verify the required parameter 'deleteDataRequest' is set
        if (deleteDataRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deleteDataRequest' when calling deleteRules");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/rules", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<DataResponse> returnType = new ParameterizedTypeReference<DataResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.DELETE, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Delete ruleset
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ArtifactResponse deleteRuleset(String client, String project, String artifact, String v) throws RestClientException {
        return deleteRulesetWithHttpInfo(client, project, artifact, v).getBody();
    }

    /**
     * Delete ruleset
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @return ResponseEntity&lt;ArtifactResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ArtifactResponse> deleteRulesetWithHttpInfo(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteRuleset");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deleteRuleset");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling deleteRuleset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> returnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.DELETE, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Delete rulesets
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param deleteArtifactRequest Remove ruleset by criteria (required)
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ArtifactResponse deleteRulesets(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws RestClientException {
        return deleteRulesetsWithHttpInfo(client, project, deleteArtifactRequest).getBody();
    }

    /**
     * Delete rulesets
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param deleteArtifactRequest Remove ruleset by criteria (required)
     * @return ResponseEntity&lt;ArtifactResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ArtifactResponse> deleteRulesetsWithHttpInfo(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws RestClientException {
        Object postBody = deleteArtifactRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteRulesets");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deleteRulesets");
        }
        
        // verify the required parameter 'deleteArtifactRequest' is set
        if (deleteArtifactRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deleteArtifactRequest' when calling deleteRulesets");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        String path = apiClient.expandPath("/compute/{client}/{project}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> returnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.DELETE, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Execute pipeline
     * Executes a pipeline
     * <p><b>200</b> - Pipeline response
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param xLogicdropRoute Route (required)
     * @param xLogicdropPath Path (required)
     * @param computePipelineRequest Pipeline request (required)
     * @return ComputePipelineResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ComputePipelineResponse executeCompute(String client, String xLogicdropRoute, String xLogicdropPath, ComputePipelineRequest computePipelineRequest) throws RestClientException {
        return executeComputeWithHttpInfo(client, xLogicdropRoute, xLogicdropPath, computePipelineRequest).getBody();
    }

    /**
     * Execute pipeline
     * Executes a pipeline
     * <p><b>200</b> - Pipeline response
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param xLogicdropRoute Route (required)
     * @param xLogicdropPath Path (required)
     * @param computePipelineRequest Pipeline request (required)
     * @return ResponseEntity&lt;ComputePipelineResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ComputePipelineResponse> executeComputeWithHttpInfo(String client, String xLogicdropRoute, String xLogicdropPath, ComputePipelineRequest computePipelineRequest) throws RestClientException {
        Object postBody = computePipelineRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling executeCompute");
        }
        
        // verify the required parameter 'xLogicdropRoute' is set
        if (xLogicdropRoute == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xLogicdropRoute' when calling executeCompute");
        }
        
        // verify the required parameter 'xLogicdropPath' is set
        if (xLogicdropPath == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xLogicdropPath' when calling executeCompute");
        }
        
        // verify the required parameter 'computePipelineRequest' is set
        if (computePipelineRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'computePipelineRequest' when calling executeCompute");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        String path = apiClient.expandPath("/compute/{client}/pipeline", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        if (xLogicdropRoute != null)
        headerParams.add("X-Logicdrop-Route", apiClient.parameterToString(xLogicdropRoute));
        if (xLogicdropPath != null)
        headerParams.add("X-Logicdrop-Path", apiClient.parameterToString(xLogicdropPath));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ComputePipelineResponse> returnType = new ParameterizedTypeReference<ComputePipelineResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Execute ruleset
     * Process rules using a simple input/output request
     * <p><b>200</b> - Processed results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * <p><b>503</b> - Container unavailable
     * @param client Client (required)
     * @param processorRequest Processor Request (required)
     * @return ProcessorResult
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ProcessorResult executeRuleset(String client, ProcessorRequest processorRequest) throws RestClientException {
        return executeRulesetWithHttpInfo(client, processorRequest).getBody();
    }

    /**
     * Execute ruleset
     * Process rules using a simple input/output request
     * <p><b>200</b> - Processed results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * <p><b>503</b> - Container unavailable
     * @param client Client (required)
     * @param processorRequest Processor Request (required)
     * @return ResponseEntity&lt;ProcessorResult&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ProcessorResult> executeRulesetWithHttpInfo(String client, ProcessorRequest processorRequest) throws RestClientException {
        Object postBody = processorRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling executeRuleset");
        }
        
        // verify the required parameter 'processorRequest' is set
        if (processorRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'processorRequest' when calling executeRuleset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        String path = apiClient.expandPath("/compute/{client}/execute", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ProcessorResult> returnType = new ParameterizedTypeReference<ProcessorResult>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Execute sample
     * Sample ruleset using a simple input/output request
     * <p><b>200</b> - Analysis results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * <p><b>503</b> - Container unavailable
     * @param client Client (required)
     * @param samplerRequest Sampling Request (required)
     * @return DesignerResult
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DesignerResult executeSample(String client, SamplerRequest samplerRequest) throws RestClientException {
        return executeSampleWithHttpInfo(client, samplerRequest).getBody();
    }

    /**
     * Execute sample
     * Sample ruleset using a simple input/output request
     * <p><b>200</b> - Analysis results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * <p><b>503</b> - Container unavailable
     * @param client Client (required)
     * @param samplerRequest Sampling Request (required)
     * @return ResponseEntity&lt;DesignerResult&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DesignerResult> executeSampleWithHttpInfo(String client, SamplerRequest samplerRequest) throws RestClientException {
        Object postBody = samplerRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling executeSample");
        }
        
        // verify the required parameter 'samplerRequest' is set
        if (samplerRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'samplerRequest' when calling executeSample");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        String path = apiClient.expandPath("/compute/{client}/sample", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<DesignerResult> returnType = new ParameterizedTypeReference<DesignerResult>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Generate ruleset
     * Generate ruleset
     * <p><b>200</b> - Generated rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @param type Compiler Type (optional, default to &quot;drl&quot;)
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public String generateRuleset(String client, String project, String artifact, String v, String type) throws RestClientException {
        return generateRulesetWithHttpInfo(client, project, artifact, v, type).getBody();
    }

    /**
     * Generate ruleset
     * Generate ruleset
     * <p><b>200</b> - Generated rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @param type Compiler Type (optional, default to &quot;drl&quot;)
     * @return ResponseEntity&lt;String&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<String> generateRulesetWithHttpInfo(String client, String project, String artifact, String v, String type) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling generateRuleset");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling generateRuleset");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling generateRuleset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/generate", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));

        final String[] accepts = { 
            "text/plain"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<String> returnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Get rule
     * Get a rule
     * <p><b>200</b> - Retrieved rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param id Rule Id (required)
     * @param v Ruleset version (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return ComputeRule
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ComputeRule getRule(String client, String project, String artifact, String id, String v, List<String> view) throws RestClientException {
        return getRuleWithHttpInfo(client, project, artifact, id, v, view).getBody();
    }

    /**
     * Get rule
     * Get a rule
     * <p><b>200</b> - Retrieved rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param id Rule Id (required)
     * @param v Ruleset version (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return ResponseEntity&lt;ComputeRule&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ComputeRule> getRuleWithHttpInfo(String client, String project, String artifact, String id, String v, List<String> view) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getRule");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getRule");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getRule");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getRule");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        uriVariables.put("id", id);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/rules/{id}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ComputeRule> returnType = new ParameterizedTypeReference<ComputeRule>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Get ruleset
     * Get an ruleset
     * <p><b>200</b> - Retrieved ruleset
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return ComputeRuleset
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ComputeRuleset getRuleset(String client, String project, String artifact, String v, List<String> view) throws RestClientException {
        return getRulesetWithHttpInfo(client, project, artifact, v, view).getBody();
    }

    /**
     * Get ruleset
     * Get an ruleset
     * <p><b>200</b> - Retrieved ruleset
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return ResponseEntity&lt;ComputeRuleset&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ComputeRuleset> getRulesetWithHttpInfo(String client, String project, String artifact, String v, List<String> view) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getRuleset");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getRuleset");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getRuleset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ComputeRuleset> returnType = new ParameterizedTypeReference<ComputeRuleset>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Get content
     * Get ruleset content
     * <p><b>200</b> - Retrieved content
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public String getRulesetContent(String client, String project, String artifact, String v) throws RestClientException {
        return getRulesetContentWithHttpInfo(client, project, artifact, v).getBody();
    }

    /**
     * Get content
     * Get ruleset content
     * <p><b>200</b> - Retrieved content
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @return ResponseEntity&lt;String&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<String> getRulesetContentWithHttpInfo(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getRulesetContent");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getRulesetContent");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getRulesetContent");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/content", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "text/plain"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<String> returnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Get example request
     * Get ruleset request example
     * <p><b>200</b> - Retrieved example
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public String getRulesetExample(String client, String project, String artifact, String v) throws RestClientException {
        return getRulesetExampleWithHttpInfo(client, project, artifact, v).getBody();
    }

    /**
     * Get example request
     * Get ruleset request example
     * <p><b>200</b> - Retrieved example
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @return ResponseEntity&lt;String&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<String> getRulesetExampleWithHttpInfo(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getRulesetExample");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getRulesetExample");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getRulesetExample");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/example", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "text/plain"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<String> returnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Get types
     * Get ruleset types
     * <p><b>200</b> - Retrieved types
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public String getRulesetTypes(String client, String project, String artifact, String v) throws RestClientException {
        return getRulesetTypesWithHttpInfo(client, project, artifact, v).getBody();
    }

    /**
     * Get types
     * Get ruleset types
     * <p><b>200</b> - Retrieved types
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @return ResponseEntity&lt;String&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<String> getRulesetTypesWithHttpInfo(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getRulesetTypes");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getRulesetTypes");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getRulesetTypes");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/types", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<String> returnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * List containers
     * Get containers possibly filtered by project and/or ruleset
     * <p><b>200</b> - Compute containers
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Filter by project containers (optional)
     * @param ruleset Filter by ruleset containers (optional)
     * @param status Container status (optional)
     * @return ContainerResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ContainerResponse listContainers(String client, String project, String ruleset, String status) throws RestClientException {
        return listContainersWithHttpInfo(client, project, ruleset, status).getBody();
    }

    /**
     * List containers
     * Get containers possibly filtered by project and/or ruleset
     * <p><b>200</b> - Compute containers
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Filter by project containers (optional)
     * @param ruleset Filter by ruleset containers (optional)
     * @param status Container status (optional)
     * @return ResponseEntity&lt;ContainerResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ContainerResponse> listContainersWithHttpInfo(String client, String project, String ruleset, String status) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listContainers");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        String path = apiClient.expandPath("/compute/{client}/containers", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "project", project));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "ruleset", ruleset));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "status", status));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ContainerResponse> returnType = new ParameterizedTypeReference<ContainerResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * List rules
     * Get rules using optional simple filters
     * <p><b>200</b> - Retrieved rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @param criteria Criteria (optional)
     * @param type Rule types (optional, default to user)
     * @param fields Any fields that match the single value only (requires a value) (optional, default to new ArrayList&lt;&gt;())
     * @param value Value to find in any fields (requires fields) (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @param filter Filters to apply (optional, default to new ArrayList&lt;&gt;())
     * @param order Fields to order by (optional, default to new ArrayList&lt;&gt;())
     * @param tags Tags to filter by (optional, default to new ArrayList&lt;&gt;())
     * @param ignoreCase Ignore case (optional, default to false)
     * @return List&lt;ComputeRule&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<ComputeRule> listRules(String client, String project, String artifact, String v, String criteria, String type, List<String> fields, String value, List<String> view, List<String> filter, List<String> order, List<String> tags, Boolean ignoreCase) throws RestClientException {
        return listRulesWithHttpInfo(client, project, artifact, v, criteria, type, fields, value, view, filter, order, tags, ignoreCase).getBody();
    }

    /**
     * List rules
     * Get rules using optional simple filters
     * <p><b>200</b> - Retrieved rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @param criteria Criteria (optional)
     * @param type Rule types (optional, default to user)
     * @param fields Any fields that match the single value only (requires a value) (optional, default to new ArrayList&lt;&gt;())
     * @param value Value to find in any fields (requires fields) (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @param filter Filters to apply (optional, default to new ArrayList&lt;&gt;())
     * @param order Fields to order by (optional, default to new ArrayList&lt;&gt;())
     * @param tags Tags to filter by (optional, default to new ArrayList&lt;&gt;())
     * @param ignoreCase Ignore case (optional, default to false)
     * @return ResponseEntity&lt;List&lt;ComputeRule&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<ComputeRule>> listRulesWithHttpInfo(String client, String project, String artifact, String v, String criteria, String type, List<String> fields, String value, List<String> view, List<String> filter, List<String> order, List<String> tags, Boolean ignoreCase) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listRules");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling listRules");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling listRules");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/rules", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "value", value));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "filter", filter));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "order", order));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "tags", tags));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "ignoreCase", ignoreCase));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<ComputeRule>> returnType = new ParameterizedTypeReference<List<ComputeRule>>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * List rules by key
     * Get rules using a single key/value
     * <p><b>200</b> - Retrieved record(s)
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param key Field name (required)
     * @param value Field value (required)
     * @param v Ruleset version (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return List&lt;ComputeRule&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<ComputeRule> listRulesBy(String client, String project, String artifact, String key, String value, String v, List<String> view) throws RestClientException {
        return listRulesByWithHttpInfo(client, project, artifact, key, value, v, view).getBody();
    }

    /**
     * List rules by key
     * Get rules using a single key/value
     * <p><b>200</b> - Retrieved record(s)
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param key Field name (required)
     * @param value Field value (required)
     * @param v Ruleset version (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return ResponseEntity&lt;List&lt;ComputeRule&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<ComputeRule>> listRulesByWithHttpInfo(String client, String project, String artifact, String key, String value, String v, List<String> view) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listRulesBy");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling listRulesBy");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling listRulesBy");
        }
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'key' when calling listRulesBy");
        }
        
        // verify the required parameter 'value' is set
        if (value == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'value' when calling listRulesBy");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        uriVariables.put("key", key);
        uriVariables.put("value", value);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/rules/by/{key}/{value}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<ComputeRule>> returnType = new ParameterizedTypeReference<List<ComputeRule>>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * List rulesets
     * Get rulesets using optional simple filters
     * <p><b>200</b> - Retrieved rulesets
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return List&lt;ComputeRuleset&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<ComputeRuleset> listRulesets(String client, String project, List<String> view) throws RestClientException {
        return listRulesetsWithHttpInfo(client, project, view).getBody();
    }

    /**
     * List rulesets
     * Get rulesets using optional simple filters
     * <p><b>200</b> - Retrieved rulesets
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return ResponseEntity&lt;List&lt;ComputeRuleset&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<ComputeRuleset>> listRulesetsWithHttpInfo(String client, String project, List<String> view) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listRulesets");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling listRulesets");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        String path = apiClient.expandPath("/compute/{client}/{project}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<ComputeRuleset>> returnType = new ParameterizedTypeReference<List<ComputeRuleset>>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Manage containers
     * Start/Update/Stop/Remove/Rebuild containers
     * <p><b>200</b> - Container status
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * <p><b>503</b> - Container unavailable
     * @param client Client (required)
     * @param action Action to perform (required)
     * @param ruleContainer Container (required)
     * @return RuleContainer
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public RuleContainer manageContainer(String client, String action, RuleContainer ruleContainer) throws RestClientException {
        return manageContainerWithHttpInfo(client, action, ruleContainer).getBody();
    }

    /**
     * Manage containers
     * Start/Update/Stop/Remove/Rebuild containers
     * <p><b>200</b> - Container status
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * <p><b>503</b> - Container unavailable
     * @param client Client (required)
     * @param action Action to perform (required)
     * @param ruleContainer Container (required)
     * @return ResponseEntity&lt;RuleContainer&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<RuleContainer> manageContainerWithHttpInfo(String client, String action, RuleContainer ruleContainer) throws RestClientException {
        Object postBody = ruleContainer;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling manageContainer");
        }
        
        // verify the required parameter 'action' is set
        if (action == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'action' when calling manageContainer");
        }
        
        // verify the required parameter 'ruleContainer' is set
        if (ruleContainer == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleContainer' when calling manageContainer");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        String path = apiClient.expandPath("/compute/{client}/containers", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "action", action));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<RuleContainer> returnType = new ParameterizedTypeReference<RuleContainer>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Save rule
     * Saves or create a rule (overwrite)
     * <p><b>200</b> - The saved rule
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param computeRule Rule to persist (required)
     * @param v Ruleset version (optional)
     * @return ComputeRule
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ComputeRule saveRule(String client, String project, String artifact, ComputeRule computeRule, String v) throws RestClientException {
        return saveRuleWithHttpInfo(client, project, artifact, computeRule, v).getBody();
    }

    /**
     * Save rule
     * Saves or create a rule (overwrite)
     * <p><b>200</b> - The saved rule
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param computeRule Rule to persist (required)
     * @param v Ruleset version (optional)
     * @return ResponseEntity&lt;ComputeRule&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ComputeRule> saveRuleWithHttpInfo(String client, String project, String artifact, ComputeRule computeRule, String v) throws RestClientException {
        Object postBody = computeRule;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling saveRule");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling saveRule");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling saveRule");
        }
        
        // verify the required parameter 'computeRule' is set
        if (computeRule == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'computeRule' when calling saveRule");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/rules", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ComputeRule> returnType = new ParameterizedTypeReference<ComputeRule>() {};
        return apiClient.invokeAPI(path, HttpMethod.PUT, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Save ruleset
     * Saves or creates an ruleset (overwrite)
     * <p><b>200</b> - The saved ruleset
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param computeRuleset Ruleset to persist (required)
     * @return ComputeRuleset
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ComputeRuleset saveRuleset(String client, String project, ComputeRuleset computeRuleset) throws RestClientException {
        return saveRulesetWithHttpInfo(client, project, computeRuleset).getBody();
    }

    /**
     * Save ruleset
     * Saves or creates an ruleset (overwrite)
     * <p><b>200</b> - The saved ruleset
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param computeRuleset Ruleset to persist (required)
     * @return ResponseEntity&lt;ComputeRuleset&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ComputeRuleset> saveRulesetWithHttpInfo(String client, String project, ComputeRuleset computeRuleset) throws RestClientException {
        Object postBody = computeRuleset;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling saveRuleset");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling saveRuleset");
        }
        
        // verify the required parameter 'computeRuleset' is set
        if (computeRuleset == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'computeRuleset' when calling saveRuleset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        String path = apiClient.expandPath("/compute/{client}/{project}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ComputeRuleset> returnType = new ParameterizedTypeReference<ComputeRuleset>() {};
        return apiClient.invokeAPI(path, HttpMethod.PUT, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Update ruleset
     * Updates one ruleset
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param updateArtifactRequest ruleset to update (required)
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ArtifactResponse updateRuleset(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws RestClientException {
        return updateRulesetWithHttpInfo(client, project, updateArtifactRequest).getBody();
    }

    /**
     * Update ruleset
     * Updates one ruleset
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param updateArtifactRequest ruleset to update (required)
     * @return ResponseEntity&lt;ArtifactResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ArtifactResponse> updateRulesetWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws RestClientException {
        Object postBody = updateArtifactRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateRuleset");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateRuleset");
        }
        
        // verify the required parameter 'updateArtifactRequest' is set
        if (updateArtifactRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateArtifactRequest' when calling updateRuleset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        String path = apiClient.expandPath("/compute/{client}/{project}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> returnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.PATCH, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Update content using file
     * Update the ruleset with custom rules using a file
     * <p><b>200</b> - The uploaded custom files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @param file File (optional)
     * @return UpdateRulesetResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public UpdateRulesetResponse updateRulesetContentFile(String client, String project, String artifact, String v, File file) throws RestClientException {
        return updateRulesetContentFileWithHttpInfo(client, project, artifact, v, file).getBody();
    }

    /**
     * Update content using file
     * Update the ruleset with custom rules using a file
     * <p><b>200</b> - The uploaded custom files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @param file File (optional)
     * @return ResponseEntity&lt;UpdateRulesetResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<UpdateRulesetResponse> updateRulesetContentFileWithHttpInfo(String client, String project, String artifact, String v, File file) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateRulesetContentFile");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateRulesetContentFile");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling updateRulesetContentFile");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/content", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        if (file != null)
            formParams.add("file", new FileSystemResource(file));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "multipart/form-data"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<UpdateRulesetResponse> returnType = new ParameterizedTypeReference<UpdateRulesetResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Update content using string
     * Update the ruleset with custom rules using a string
     * <p><b>200</b> - The update results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @param body  (optional)
     * @return UpdateRulesetResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public UpdateRulesetResponse updateRulesetContentText(String client, String project, String artifact, String v, String body) throws RestClientException {
        return updateRulesetContentTextWithHttpInfo(client, project, artifact, v, body).getBody();
    }

    /**
     * Update content using string
     * Update the ruleset with custom rules using a string
     * <p><b>200</b> - The update results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @param body  (optional)
     * @return ResponseEntity&lt;UpdateRulesetResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<UpdateRulesetResponse> updateRulesetContentTextWithHttpInfo(String client, String project, String artifact, String v, String body) throws RestClientException {
        Object postBody = body;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateRulesetContentText");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateRulesetContentText");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling updateRulesetContentText");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/content", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "text/plain"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<UpdateRulesetResponse> returnType = new ParameterizedTypeReference<UpdateRulesetResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.PATCH, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Update example request
     * Update the ruleset with an example request
     * <p><b>200</b> - The update results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @param body  (optional)
     * @return UpdateRulesetResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public UpdateRulesetResponse updateRulesetExample(String client, String project, String artifact, String v, String body) throws RestClientException {
        return updateRulesetExampleWithHttpInfo(client, project, artifact, v, body).getBody();
    }

    /**
     * Update example request
     * Update the ruleset with an example request
     * <p><b>200</b> - The update results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @param body  (optional)
     * @return ResponseEntity&lt;UpdateRulesetResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<UpdateRulesetResponse> updateRulesetExampleWithHttpInfo(String client, String project, String artifact, String v, String body) throws RestClientException {
        Object postBody = body;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateRulesetExample");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateRulesetExample");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling updateRulesetExample");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/example", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "text/plain"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<UpdateRulesetResponse> returnType = new ParameterizedTypeReference<UpdateRulesetResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.PATCH, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Update ruleset types
     * Saves or creates an ruleset types (overwrite)
     * <p><b>200</b> - The saved ruleset
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param updateRuleTypesRequest Rule types to persist (required)
     * @param v Ruleset version (optional)
     * @return ComputeRuleset
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ComputeRuleset updateRulesetTypes(String client, String project, String artifact, UpdateRuleTypesRequest updateRuleTypesRequest, String v) throws RestClientException {
        return updateRulesetTypesWithHttpInfo(client, project, artifact, updateRuleTypesRequest, v).getBody();
    }

    /**
     * Update ruleset types
     * Saves or creates an ruleset types (overwrite)
     * <p><b>200</b> - The saved ruleset
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param updateRuleTypesRequest Rule types to persist (required)
     * @param v Ruleset version (optional)
     * @return ResponseEntity&lt;ComputeRuleset&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ComputeRuleset> updateRulesetTypesWithHttpInfo(String client, String project, String artifact, UpdateRuleTypesRequest updateRuleTypesRequest, String v) throws RestClientException {
        Object postBody = updateRuleTypesRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateRulesetTypes");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateRulesetTypes");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling updateRulesetTypes");
        }
        
        // verify the required parameter 'updateRuleTypesRequest' is set
        if (updateRuleTypesRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateRuleTypesRequest' when calling updateRulesetTypes");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/types", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ComputeRuleset> returnType = new ParameterizedTypeReference<ComputeRuleset>() {};
        return apiClient.invokeAPI(path, HttpMethod.PUT, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Update rulesets
     * Updates multiple rules
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param updateArtifactRequest Rules to update (required)
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ArtifactResponse updateRulesets(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws RestClientException {
        return updateRulesetsWithHttpInfo(client, project, updateArtifactRequest).getBody();
    }

    /**
     * Update rulesets
     * Updates multiple rules
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param updateArtifactRequest Rules to update (required)
     * @return ResponseEntity&lt;ArtifactResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ArtifactResponse> updateRulesetsWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws RestClientException {
        Object postBody = updateArtifactRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateRulesets");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateRulesets");
        }
        
        // verify the required parameter 'updateArtifactRequest' is set
        if (updateArtifactRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateArtifactRequest' when calling updateRulesets");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        String path = apiClient.expandPath("/compute/{client}/{project}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> returnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Upload dataset
     * Upload rule data (Excel workbook and CSVs)
     * <p><b>200</b> - The saved data
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param file File (optional)
     * @return UploadResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public UploadResponse uploadDatasets(String client, String project, File file) throws RestClientException {
        return uploadDatasetsWithHttpInfo(client, project, file).getBody();
    }

    /**
     * Upload dataset
     * Upload rule data (Excel workbook and CSVs)
     * <p><b>200</b> - The saved data
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param file File (optional)
     * @return ResponseEntity&lt;UploadResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<UploadResponse> uploadDatasetsWithHttpInfo(String client, String project, File file) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling uploadDatasets");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling uploadDatasets");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        String path = apiClient.expandPath("/compute/{client}/{project}/upload", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        if (file != null)
            formParams.add("file", new FileSystemResource(file));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "multipart/form-data"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<UploadResponse> returnType = new ParameterizedTypeReference<UploadResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Upload workbook
     * Upload a decision table (Excel workbook)
     * <p><b>200</b> - The saved rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @param merge Merge or replace rules (optional, default to false)
     * @param file File (optional)
     * @return UploadResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public UploadResponse uploadWorkbook(String client, String project, String artifact, String v, Boolean merge, File file) throws RestClientException {
        return uploadWorkbookWithHttpInfo(client, project, artifact, v, merge, file).getBody();
    }

    /**
     * Upload workbook
     * Upload a decision table (Excel workbook)
     * <p><b>200</b> - The saved rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Ruleset name (required)
     * @param v Ruleset version (optional)
     * @param merge Merge or replace rules (optional, default to false)
     * @param file File (optional)
     * @return ResponseEntity&lt;UploadResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<UploadResponse> uploadWorkbookWithHttpInfo(String client, String project, String artifact, String v, Boolean merge, File file) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling uploadWorkbook");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling uploadWorkbook");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling uploadWorkbook");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/compute/{client}/{project}/{artifact}/upload", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "merge", merge));

        if (file != null)
            formParams.add("file", new FileSystemResource(file));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "multipart/form-data"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<UploadResponse> returnType = new ParameterizedTypeReference<UploadResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * View ruleset source
     * Generate ruleset source for analysis
     * <p><b>200</b> - Generated rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client (required)
     * @param generateAllRequest Analysis source request (required)
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public String viewRuleset(String client, GenerateAllRequest generateAllRequest) throws RestClientException {
        return viewRulesetWithHttpInfo(client, generateAllRequest).getBody();
    }

    /**
     * View ruleset source
     * Generate ruleset source for analysis
     * <p><b>200</b> - Generated rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client (required)
     * @param generateAllRequest Analysis source request (required)
     * @return ResponseEntity&lt;String&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<String> viewRulesetWithHttpInfo(String client, GenerateAllRequest generateAllRequest) throws RestClientException {
        Object postBody = generateAllRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling viewRuleset");
        }
        
        // verify the required parameter 'generateAllRequest' is set
        if (generateAllRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'generateAllRequest' when calling viewRuleset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        String path = apiClient.expandPath("/compute/{client}/analyze/source", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "text/plain"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<String> returnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * View single source
     * Generate a single ruleset source for analysis
     * <p><b>200</b> - Generated rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client (required)
     * @param typeOrId ID or type (required)
     * @param generateOneRequest Analysis source request (required)
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public String viewSource(String client, String typeOrId, GenerateOneRequest generateOneRequest) throws RestClientException {
        return viewSourceWithHttpInfo(client, typeOrId, generateOneRequest).getBody();
    }

    /**
     * View single source
     * Generate a single ruleset source for analysis
     * <p><b>200</b> - Generated rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client (required)
     * @param typeOrId ID or type (required)
     * @param generateOneRequest Analysis source request (required)
     * @return ResponseEntity&lt;String&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<String> viewSourceWithHttpInfo(String client, String typeOrId, GenerateOneRequest generateOneRequest) throws RestClientException {
        Object postBody = generateOneRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling viewSource");
        }
        
        // verify the required parameter 'typeOrId' is set
        if (typeOrId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'typeOrId' when calling viewSource");
        }
        
        // verify the required parameter 'generateOneRequest' is set
        if (generateOneRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'generateOneRequest' when calling viewSource");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("typeOrId", typeOrId);
        String path = apiClient.expandPath("/compute/{client}/analyze/source/{typeOrId}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "text/plain"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<String> returnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
}
