package io.logicdrop.openapi.webflux.api;

import io.logicdrop.openapi.webflux.ApiClient;

import io.logicdrop.openapi.models.ActivateRulesetResponse;
import io.logicdrop.openapi.models.AnalyzerRequest;
import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.ComputePipelineRequest;
import io.logicdrop.openapi.models.ComputePipelineResponse;
import io.logicdrop.openapi.models.ComputeRule;
import io.logicdrop.openapi.models.ComputeRuleset;
import io.logicdrop.openapi.models.ContainerResponse;
import io.logicdrop.openapi.models.DataResponse;
import io.logicdrop.openapi.models.DeleteArtifactRequest;
import io.logicdrop.openapi.models.DeleteDataRequest;
import io.logicdrop.openapi.models.DesignerResult;
import java.io.File;
import io.logicdrop.openapi.models.GenerateAllRequest;
import io.logicdrop.openapi.models.GenerateOneRequest;
import io.logicdrop.openapi.models.ProcessorRequest;
import io.logicdrop.openapi.models.ProcessorResult;
import io.logicdrop.openapi.models.RuleContainer;
import io.logicdrop.openapi.models.SamplerRequest;
import io.logicdrop.openapi.models.UpdateArtifactRequest;
import io.logicdrop.openapi.models.UpdateRuleTypesRequest;
import io.logicdrop.openapi.models.UpdateRulesetResponse;
import io.logicdrop.openapi.models.UploadResponse;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;


public class ComputeServicesApi {
    private ApiClient apiClient;

    public ComputeServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public ComputeServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate ruleset
     * Activate a ruleset
     * <p><b>200</b> - Ruleset state
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param v Ruleset version
     * @return ActivateRulesetResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ActivateRulesetResponse> activateRuleset(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling activateRuleset");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling activateRuleset");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling activateRuleset");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ActivateRulesetResponse> localVarReturnType = new ParameterizedTypeReference<ActivateRulesetResponse>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}/activate", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Analyze ruleset
     * Analyze ruleset
     * <p><b>200</b> - Analysis results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * <p><b>503</b> - Container unavailable
     * @param client Client
     * @param analyzerRequest Analysis execute request
     * @return DesignerResult
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<DesignerResult> analyzeRuleset(String client, AnalyzerRequest analyzerRequest) throws RestClientException {
        Object postBody = analyzerRequest;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling analyzeRuleset");
        }
        // verify the required parameter 'analyzerRequest' is set
        if (analyzerRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'analyzerRequest' when calling analyzeRuleset");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<DesignerResult> localVarReturnType = new ParameterizedTypeReference<DesignerResult>() {};
        return apiClient.invokeAPI("/compute/{client}/analyze", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Deactivate ruleset
     * Deactivate a ruleset
     * <p><b>200</b> - Ruleset state
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param v Ruleset version
     * @return ActivateRulesetResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ActivateRulesetResponse> deactivateRuleset(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deactivateRuleset");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deactivateRuleset");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling deactivateRuleset");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ActivateRulesetResponse> localVarReturnType = new ParameterizedTypeReference<ActivateRulesetResponse>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}/activate", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Delete rule
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param id Rule Id
     * @param v Ruleset version
     * @return DataResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<DataResponse> deleteRule(String client, String project, String artifact, String id, String v) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteRule");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deleteRule");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling deleteRule");
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling deleteRule");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);
        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<DataResponse> localVarReturnType = new ParameterizedTypeReference<DataResponse>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}/rules/{id}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Delete rules
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param deleteDataRequest Remove rules by criteria
     * @param v Ruleset version
     * @return DataResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<DataResponse> deleteRules(String client, String project, String artifact, DeleteDataRequest deleteDataRequest, String v) throws RestClientException {
        Object postBody = deleteDataRequest;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteRules");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deleteRules");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling deleteRules");
        }
        // verify the required parameter 'deleteDataRequest' is set
        if (deleteDataRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deleteDataRequest' when calling deleteRules");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<DataResponse> localVarReturnType = new ParameterizedTypeReference<DataResponse>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}/rules", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Delete ruleset
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param v Ruleset version
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ArtifactResponse> deleteRuleset(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteRuleset");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deleteRuleset");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling deleteRuleset");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> localVarReturnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Delete rulesets
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param deleteArtifactRequest Remove ruleset by criteria
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ArtifactResponse> deleteRulesets(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws RestClientException {
        Object postBody = deleteArtifactRequest;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteRulesets");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deleteRulesets");
        }
        // verify the required parameter 'deleteArtifactRequest' is set
        if (deleteArtifactRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deleteArtifactRequest' when calling deleteRulesets");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> localVarReturnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Execute pipeline
     * Executes a pipeline
     * <p><b>200</b> - Pipeline response
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param xLogicdropRoute Route
     * @param xLogicdropPath Path
     * @param computePipelineRequest Pipeline request
     * @return ComputePipelineResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ComputePipelineResponse> executeCompute(String client, String xLogicdropRoute, String xLogicdropPath, ComputePipelineRequest computePipelineRequest) throws RestClientException {
        Object postBody = computePipelineRequest;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling executeCompute");
        }
        // verify the required parameter 'xLogicdropRoute' is set
        if (xLogicdropRoute == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xLogicdropRoute' when calling executeCompute");
        }
        // verify the required parameter 'xLogicdropPath' is set
        if (xLogicdropPath == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xLogicdropPath' when calling executeCompute");
        }
        // verify the required parameter 'computePipelineRequest' is set
        if (computePipelineRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'computePipelineRequest' when calling executeCompute");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (xLogicdropRoute != null)
        headerParams.add("X-Logicdrop-Route", apiClient.parameterToString(xLogicdropRoute));
        if (xLogicdropPath != null)
        headerParams.add("X-Logicdrop-Path", apiClient.parameterToString(xLogicdropPath));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ComputePipelineResponse> localVarReturnType = new ParameterizedTypeReference<ComputePipelineResponse>() {};
        return apiClient.invokeAPI("/compute/{client}/pipeline", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Execute ruleset
     * Process rules using a simple input/output request
     * <p><b>200</b> - Processed results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * <p><b>503</b> - Container unavailable
     * @param client Client
     * @param processorRequest Processor Request
     * @return ProcessorResult
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ProcessorResult> executeRuleset(String client, ProcessorRequest processorRequest) throws RestClientException {
        Object postBody = processorRequest;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling executeRuleset");
        }
        // verify the required parameter 'processorRequest' is set
        if (processorRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'processorRequest' when calling executeRuleset");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ProcessorResult> localVarReturnType = new ParameterizedTypeReference<ProcessorResult>() {};
        return apiClient.invokeAPI("/compute/{client}/execute", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Execute sample
     * Sample ruleset using a simple input/output request
     * <p><b>200</b> - Analysis results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * <p><b>503</b> - Container unavailable
     * @param client Client
     * @param samplerRequest Sampling Request
     * @return DesignerResult
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<DesignerResult> executeSample(String client, SamplerRequest samplerRequest) throws RestClientException {
        Object postBody = samplerRequest;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling executeSample");
        }
        // verify the required parameter 'samplerRequest' is set
        if (samplerRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'samplerRequest' when calling executeSample");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<DesignerResult> localVarReturnType = new ParameterizedTypeReference<DesignerResult>() {};
        return apiClient.invokeAPI("/compute/{client}/sample", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Generate ruleset
     * Generate ruleset
     * <p><b>200</b> - Generated rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param v Ruleset version
     * @param type Compiler Type
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<String> generateRuleset(String client, String project, String artifact, String v, String type) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling generateRuleset");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling generateRuleset");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling generateRuleset");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));

        final String[] localVarAccepts = { 
            "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}/generate", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Get rule
     * Get a rule
     * <p><b>200</b> - Retrieved rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param id Rule Id
     * @param v Ruleset version
     * @param view Fields to return in the results
     * @return ComputeRule
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ComputeRule> getRule(String client, String project, String artifact, String id, String v, List<String> view) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getRule");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getRule");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getRule");
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getRule");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);
        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ComputeRule> localVarReturnType = new ParameterizedTypeReference<ComputeRule>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}/rules/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Get ruleset
     * Get an ruleset
     * <p><b>200</b> - Retrieved ruleset
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param v Ruleset version
     * @param view Fields to return in the results
     * @return ComputeRuleset
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ComputeRuleset> getRuleset(String client, String project, String artifact, String v, List<String> view) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getRuleset");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getRuleset");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getRuleset");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ComputeRuleset> localVarReturnType = new ParameterizedTypeReference<ComputeRuleset>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Get content
     * Get ruleset content
     * <p><b>200</b> - Retrieved content
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param v Ruleset version
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<String> getRulesetContent(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getRulesetContent");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getRulesetContent");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getRulesetContent");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] localVarAccepts = { 
            "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}/content", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Get example request
     * Get ruleset request example
     * <p><b>200</b> - Retrieved example
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param v Ruleset version
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<String> getRulesetExample(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getRulesetExample");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getRulesetExample");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getRulesetExample");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] localVarAccepts = { 
            "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}/example", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Get types
     * Get ruleset types
     * <p><b>200</b> - Retrieved types
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param v Ruleset version
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<String> getRulesetTypes(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getRulesetTypes");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getRulesetTypes");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getRulesetTypes");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}/types", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * List containers
     * Get containers possibly filtered by project and/or ruleset
     * <p><b>200</b> - Compute containers
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Filter by project containers
     * @param ruleset Filter by ruleset containers
     * @param status Container status
     * @return ContainerResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ContainerResponse> listContainers(String client, String project, String ruleset, String status) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listContainers");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "project", project));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "ruleset", ruleset));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "status", status));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ContainerResponse> localVarReturnType = new ParameterizedTypeReference<ContainerResponse>() {};
        return apiClient.invokeAPI("/compute/{client}/containers", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * List rules
     * Get rules using optional simple filters
     * <p><b>200</b> - Retrieved rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param v Ruleset version
     * @param criteria Criteria
     * @param type Rule types
     * @param fields Any fields that match the single value only (requires a value)
     * @param value Value to find in any fields (requires fields)
     * @param view Fields to return in the results
     * @param filter Filters to apply
     * @param order Fields to order by
     * @param tags Tags to filter by
     * @param ignoreCase Ignore case
     * @return List&lt;ComputeRule&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Flux<ComputeRule> listRules(String client, String project, String artifact, String v, String criteria, String type, List<String> fields, String value, List<String> view, List<String> filter, List<String> order, List<String> tags, Boolean ignoreCase) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listRules");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling listRules");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling listRules");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "value", value));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "filter", filter));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "order", order));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "tags", tags));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "ignoreCase", ignoreCase));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ComputeRule> localVarReturnType = new ParameterizedTypeReference<ComputeRule>() {};
        return apiClient.invokeFluxAPI("/compute/{client}/{project}/{artifact}/rules", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * List rules by key
     * Get rules using a single key/value
     * <p><b>200</b> - Retrieved record(s)
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param key Field name
     * @param value Field value
     * @param v Ruleset version
     * @param view Fields to return in the results
     * @return List&lt;ComputeRule&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Flux<ComputeRule> listRulesBy(String client, String project, String artifact, String key, String value, String v, List<String> view) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listRulesBy");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling listRulesBy");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling listRulesBy");
        }
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'key' when calling listRulesBy");
        }
        // verify the required parameter 'value' is set
        if (value == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'value' when calling listRulesBy");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);
        pathParams.put("key", key);
        pathParams.put("value", value);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ComputeRule> localVarReturnType = new ParameterizedTypeReference<ComputeRule>() {};
        return apiClient.invokeFluxAPI("/compute/{client}/{project}/{artifact}/rules/by/{key}/{value}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * List rulesets
     * Get rulesets using optional simple filters
     * <p><b>200</b> - Retrieved rulesets
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param view Fields to return in the results
     * @return List&lt;ComputeRuleset&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Flux<ComputeRuleset> listRulesets(String client, String project, List<String> view) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listRulesets");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling listRulesets");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ComputeRuleset> localVarReturnType = new ParameterizedTypeReference<ComputeRuleset>() {};
        return apiClient.invokeFluxAPI("/compute/{client}/{project}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Manage containers
     * Start/Update/Stop/Remove/Rebuild containers
     * <p><b>200</b> - Container status
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * <p><b>503</b> - Container unavailable
     * @param client Client
     * @param action Action to perform
     * @param ruleContainer Container
     * @return RuleContainer
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<RuleContainer> manageContainer(String client, String action, RuleContainer ruleContainer) throws RestClientException {
        Object postBody = ruleContainer;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling manageContainer");
        }
        // verify the required parameter 'action' is set
        if (action == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'action' when calling manageContainer");
        }
        // verify the required parameter 'ruleContainer' is set
        if (ruleContainer == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleContainer' when calling manageContainer");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "action", action));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<RuleContainer> localVarReturnType = new ParameterizedTypeReference<RuleContainer>() {};
        return apiClient.invokeAPI("/compute/{client}/containers", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Save rule
     * Saves or create a rule (overwrite)
     * <p><b>200</b> - The saved rule
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param computeRule Rule to persist
     * @param v Ruleset version
     * @return ComputeRule
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ComputeRule> saveRule(String client, String project, String artifact, ComputeRule computeRule, String v) throws RestClientException {
        Object postBody = computeRule;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling saveRule");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling saveRule");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling saveRule");
        }
        // verify the required parameter 'computeRule' is set
        if (computeRule == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'computeRule' when calling saveRule");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ComputeRule> localVarReturnType = new ParameterizedTypeReference<ComputeRule>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}/rules", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Save ruleset
     * Saves or creates an ruleset (overwrite)
     * <p><b>200</b> - The saved ruleset
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param computeRuleset Ruleset to persist
     * @return ComputeRuleset
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ComputeRuleset> saveRuleset(String client, String project, ComputeRuleset computeRuleset) throws RestClientException {
        Object postBody = computeRuleset;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling saveRuleset");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling saveRuleset");
        }
        // verify the required parameter 'computeRuleset' is set
        if (computeRuleset == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'computeRuleset' when calling saveRuleset");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ComputeRuleset> localVarReturnType = new ParameterizedTypeReference<ComputeRuleset>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Update ruleset
     * Updates one ruleset
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param updateArtifactRequest ruleset to update
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ArtifactResponse> updateRuleset(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws RestClientException {
        Object postBody = updateArtifactRequest;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateRuleset");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateRuleset");
        }
        // verify the required parameter 'updateArtifactRequest' is set
        if (updateArtifactRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateArtifactRequest' when calling updateRuleset");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> localVarReturnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Update content using file
     * Update the ruleset with custom rules using a file
     * <p><b>200</b> - The uploaded custom files
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param v Ruleset version
     * @param file File
     * @return UpdateRulesetResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<UpdateRulesetResponse> updateRulesetContentFile(String client, String project, String artifact, String v, File file) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateRulesetContentFile");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateRulesetContentFile");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling updateRulesetContentFile");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        if (file != null)
            formParams.add("file", new FileSystemResource(file));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<UpdateRulesetResponse> localVarReturnType = new ParameterizedTypeReference<UpdateRulesetResponse>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}/content", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Update content using string
     * Update the ruleset with custom rules using a string
     * <p><b>200</b> - The update results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param v Ruleset version
     * @param body The body parameter
     * @return UpdateRulesetResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<UpdateRulesetResponse> updateRulesetContentText(String client, String project, String artifact, String v, String body) throws RestClientException {
        Object postBody = body;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateRulesetContentText");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateRulesetContentText");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling updateRulesetContentText");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "text/plain"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<UpdateRulesetResponse> localVarReturnType = new ParameterizedTypeReference<UpdateRulesetResponse>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}/content", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Update example request
     * Update the ruleset with an example request
     * <p><b>200</b> - The update results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param v Ruleset version
     * @param body The body parameter
     * @return UpdateRulesetResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<UpdateRulesetResponse> updateRulesetExample(String client, String project, String artifact, String v, String body) throws RestClientException {
        Object postBody = body;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateRulesetExample");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateRulesetExample");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling updateRulesetExample");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "text/plain"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<UpdateRulesetResponse> localVarReturnType = new ParameterizedTypeReference<UpdateRulesetResponse>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}/example", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Update ruleset types
     * Saves or creates an ruleset types (overwrite)
     * <p><b>200</b> - The saved ruleset
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param updateRuleTypesRequest Rule types to persist
     * @param v Ruleset version
     * @return ComputeRuleset
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ComputeRuleset> updateRulesetTypes(String client, String project, String artifact, UpdateRuleTypesRequest updateRuleTypesRequest, String v) throws RestClientException {
        Object postBody = updateRuleTypesRequest;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateRulesetTypes");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateRulesetTypes");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling updateRulesetTypes");
        }
        // verify the required parameter 'updateRuleTypesRequest' is set
        if (updateRuleTypesRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateRuleTypesRequest' when calling updateRulesetTypes");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ComputeRuleset> localVarReturnType = new ParameterizedTypeReference<ComputeRuleset>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}/types", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Update rulesets
     * Updates multiple rules
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param updateArtifactRequest Rules to update
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ArtifactResponse> updateRulesets(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws RestClientException {
        Object postBody = updateArtifactRequest;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateRulesets");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateRulesets");
        }
        // verify the required parameter 'updateArtifactRequest' is set
        if (updateArtifactRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateArtifactRequest' when calling updateRulesets");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> localVarReturnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Upload dataset
     * Upload rule data (Excel workbook and CSVs)
     * <p><b>200</b> - The saved data
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param file File
     * @return UploadResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<UploadResponse> uploadDatasets(String client, String project, File file) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling uploadDatasets");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling uploadDatasets");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (file != null)
            formParams.add("file", new FileSystemResource(file));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<UploadResponse> localVarReturnType = new ParameterizedTypeReference<UploadResponse>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/upload", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Upload workbook
     * Upload a decision table (Excel workbook)
     * <p><b>200</b> - The saved rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Ruleset name
     * @param v Ruleset version
     * @param merge Merge or replace rules
     * @param file File
     * @return UploadResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<UploadResponse> uploadWorkbook(String client, String project, String artifact, String v, Boolean merge, File file) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling uploadWorkbook");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling uploadWorkbook");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling uploadWorkbook");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "merge", merge));

        if (file != null)
            formParams.add("file", new FileSystemResource(file));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<UploadResponse> localVarReturnType = new ParameterizedTypeReference<UploadResponse>() {};
        return apiClient.invokeAPI("/compute/{client}/{project}/{artifact}/upload", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * View ruleset source
     * Generate ruleset source for analysis
     * <p><b>200</b> - Generated rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client
     * @param generateAllRequest Analysis source request
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<String> viewRuleset(String client, GenerateAllRequest generateAllRequest) throws RestClientException {
        Object postBody = generateAllRequest;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling viewRuleset");
        }
        // verify the required parameter 'generateAllRequest' is set
        if (generateAllRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'generateAllRequest' when calling viewRuleset");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI("/compute/{client}/analyze/source", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * View single source
     * Generate a single ruleset source for analysis
     * <p><b>200</b> - Generated rules
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client
     * @param typeOrId ID or type
     * @param generateOneRequest Analysis source request
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<String> viewSource(String client, String typeOrId, GenerateOneRequest generateOneRequest) throws RestClientException {
        Object postBody = generateOneRequest;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling viewSource");
        }
        // verify the required parameter 'typeOrId' is set
        if (typeOrId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'typeOrId' when calling viewSource");
        }
        // verify the required parameter 'generateOneRequest' is set
        if (generateOneRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'generateOneRequest' when calling viewSource");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("typeOrId", typeOrId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI("/compute/{client}/analyze/source/{typeOrId}", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}
