package io.logicdrop.openapi.webflux.api;

import io.logicdrop.openapi.webflux.ApiClient;

import io.logicdrop.openapi.models.ArtifactResponse;
import io.logicdrop.openapi.models.DeleteArtifactRequest;
import java.io.File;
import io.logicdrop.openapi.models.Pipeline;
import io.logicdrop.openapi.models.UpdateArtifactRequest;
import io.logicdrop.openapi.models.UpdatePipelineResponse;
import io.logicdrop.openapi.models.UploadResponse;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;


public class PipelineServicesApi {
    private ApiClient apiClient;

    public PipelineServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public PipelineServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Delete pipeline
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Pipeline name
     * @param v Pipeline version
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ArtifactResponse> deletePipeline(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deletePipeline");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deletePipeline");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling deletePipeline");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> localVarReturnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI("/pipelines/{client}/{project}/{artifact}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Delete pipelines
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param deleteArtifactRequest Remove pipelines by criteria
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ArtifactResponse> deletePipelines(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws RestClientException {
        Object postBody = deleteArtifactRequest;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deletePipelines");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deletePipelines");
        }
        // verify the required parameter 'deleteArtifactRequest' is set
        if (deleteArtifactRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deleteArtifactRequest' when calling deletePipelines");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> localVarReturnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI("/pipelines/{client}/{project}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Get pipeline
     * Get an pipeline
     * <p><b>200</b> - Retrieved pipeline
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Pipeline name
     * @param v Pipeline version
     * @param view Fields to return in the results
     * @return Pipeline
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<Pipeline> getPipeline(String client, String project, String artifact, String v, List<String> view) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getPipeline");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getPipeline");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getPipeline");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<Pipeline> localVarReturnType = new ParameterizedTypeReference<Pipeline>() {};
        return apiClient.invokeAPI("/pipelines/{client}/{project}/{artifact}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Get content
     * Get pipeline content
     * <p><b>200</b> - Retrieved content
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Pipeline name
     * @param v Pipeline version
     * @return String
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<String> getPipelineContent(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getPipelineContent");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getPipelineContent");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getPipelineContent");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] localVarAccepts = { 
            "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>() {};
        return apiClient.invokeAPI("/pipelines/{client}/{project}/{artifact}/content", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * List pipelines
     * Get pipelines using optional simple filters
     * <p><b>200</b> - Retrieved pipelines
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param view Fields to return in the results
     * @return List&lt;Pipeline&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Flux<Pipeline> listPipelines(String client, String project, List<String> view) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listPipelines");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling listPipelines");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<Pipeline> localVarReturnType = new ParameterizedTypeReference<Pipeline>() {};
        return apiClient.invokeFluxAPI("/pipelines/{client}/{project}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Save pipeline
     * Saves or creates a pipeline (overwrite)
     * <p><b>200</b> - The saved pipeline
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param pipeline Pipeline to persist
     * @return Pipeline
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<Pipeline> savePipeline(String client, String project, Pipeline pipeline) throws RestClientException {
        Object postBody = pipeline;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling savePipeline");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling savePipeline");
        }
        // verify the required parameter 'pipeline' is set
        if (pipeline == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pipeline' when calling savePipeline");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<Pipeline> localVarReturnType = new ParameterizedTypeReference<Pipeline>() {};
        return apiClient.invokeAPI("/pipelines/{client}/{project}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Update pipeline
     * Updates one pipeline
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param updateArtifactRequest Pipelines to update
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ArtifactResponse> updatePipeline(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws RestClientException {
        Object postBody = updateArtifactRequest;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updatePipeline");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updatePipeline");
        }
        // verify the required parameter 'updateArtifactRequest' is set
        if (updateArtifactRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateArtifactRequest' when calling updatePipeline");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> localVarReturnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI("/pipelines/{client}/{project}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Update content
     * Update the pipeline
     * <p><b>200</b> - The update results
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Pipeline name
     * @param v Pipeline version
     * @param body The body parameter
     * @return UpdatePipelineResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<UpdatePipelineResponse> updatePipelineContent(String client, String project, String artifact, String v, String body) throws RestClientException {
        Object postBody = body;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updatePipelineContent");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updatePipelineContent");
        }
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling updatePipelineContent");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "text/plain"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<UpdatePipelineResponse> localVarReturnType = new ParameterizedTypeReference<UpdatePipelineResponse>() {};
        return apiClient.invokeAPI("/pipelines/{client}/{project}/{artifact}/content", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Update pipelines
     * Updates multiple pipelines
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param updateArtifactRequest Pipelines to update
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ArtifactResponse> updatePipelines(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws RestClientException {
        Object postBody = updateArtifactRequest;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updatePipelines");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updatePipelines");
        }
        // verify the required parameter 'updateArtifactRequest' is set
        if (updateArtifactRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateArtifactRequest' when calling updatePipelines");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> localVarReturnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI("/pipelines/{client}/{project}", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
    /**
     * Upload pipeline
     * Upload pipeline
     * <p><b>200</b> - The saved data
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param file File
     * @return UploadResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<UploadResponse> uploadPipeline(String client, String project, File file) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling uploadPipeline");
        }
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling uploadPipeline");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("project", project);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (file != null)
            formParams.add("file", new FileSystemResource(file));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<UploadResponse> localVarReturnType = new ParameterizedTypeReference<UploadResponse>() {};
        return apiClient.invokeAPI("/pipelines/{client}/{project}/upload", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}
