/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.webflux.api;

import io.logicdrop.openapi.models.PipelineMessage;
import io.logicdrop.openapi.webflux.ApiClient;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import reactor.core.publisher.Mono;

public class PipelineServicesApi {
    private ApiClient apiClient;

    public PipelineServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public PipelineServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Mono<PipelineMessage> executePipeline(String client, String route, PipelineMessage pipelineMessage) throws RestClientException {
        PipelineMessage postBody = pipelineMessage;
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling executePipeline");
        }
        if (route == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'route' when calling executePipeline");
        }
        if (pipelineMessage == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pipelineMessage' when calling executePipeline");
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("route", route);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        ParameterizedTypeReference<PipelineMessage> localVarReturnType = new ParameterizedTypeReference<PipelineMessage>(){};
        return this.apiClient.invokeAPI("/pipeline/{client}/{route}", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PipelineMessage> executePipelineRoute(String client, String route, PipelineMessage pipelineMessage) throws RestClientException {
        PipelineMessage postBody = pipelineMessage;
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling executePipelineRoute");
        }
        if (route == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'route' when calling executePipelineRoute");
        }
        if (pipelineMessage == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pipelineMessage' when calling executePipelineRoute");
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("route", route);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        ParameterizedTypeReference<PipelineMessage> localVarReturnType = new ParameterizedTypeReference<PipelineMessage>(){};
        return this.apiClient.invokeAPI("/pipeline/{client}/execute", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

