/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.webflux.api;

import io.logicdrop.openapi.models.EmailMessage;
import io.logicdrop.openapi.models.EmailResult;
import io.logicdrop.openapi.models.EmailWithAttachment;
import io.logicdrop.openapi.webflux.ApiClient;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import reactor.core.publisher.Mono;

public class EmailServicesApi {
    private ApiClient apiClient;

    public EmailServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public EmailServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Mono<EmailResult> sendEmail(String client, EmailMessage emailMessage) throws RestClientException {
        EmailMessage postBody = emailMessage;
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling sendEmail");
        }
        if (emailMessage == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'emailMessage' when calling sendEmail");
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        ParameterizedTypeReference<EmailResult> localVarReturnType = new ParameterizedTypeReference<EmailResult>(){};
        return this.apiClient.invokeAPI("/email/{client}", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EmailResult> sendWithAttachment(String client, EmailWithAttachment emailWithAttachment) throws RestClientException {
        EmailWithAttachment postBody = emailWithAttachment;
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling sendWithAttachment");
        }
        if (emailWithAttachment == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'emailWithAttachment' when calling sendWithAttachment");
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        ParameterizedTypeReference<EmailResult> localVarReturnType = new ParameterizedTypeReference<EmailResult>(){};
        return this.apiClient.invokeAPI("/email/{client}/send", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

