package io.logicdrop.openapi.webflux.api;

import io.logicdrop.openapi.webflux.ApiClient;

import io.logicdrop.openapi.models.PipelineMessage;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;


public class PipelineServicesApi {
    private ApiClient apiClient;

    public PipelineServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public PipelineServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Execute pipeline
     * Executes a pipeline
     * <p><b>200</b> - Pipeline response
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param route Route
     * @param pipelineMessage Pipeline request
     * @return PipelineMessage
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<PipelineMessage> executePipeline(String client, String route, PipelineMessage pipelineMessage) throws RestClientException {
        Object postBody = pipelineMessage;
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling executePipeline");
        }
        // verify the required parameter 'route' is set
        if (route == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'route' when calling executePipeline");
        }
        // verify the required parameter 'pipelineMessage' is set
        if (pipelineMessage == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pipelineMessage' when calling executePipeline");
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("client", client);
        pathParams.put("route", route);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<PipelineMessage> localVarReturnType = new ParameterizedTypeReference<PipelineMessage>() {};
        return apiClient.invokeAPI("/pipeline/{client}/{route}", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}
