/*
 * Decompiled with CFR 0.152.
 */
package io.logicdrop.openapi.webflux.api;

import io.logicdrop.openapi.models.FileResult;
import io.logicdrop.openapi.webflux.ApiClient;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ContentServicesApi {
    private ApiClient apiClient;

    public ContentServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public ContentServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Flux<FileResult> deleteContent(String client, String folders, String filename, String extension) throws RestClientException {
        Object postBody = null;
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteContent");
        }
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling deleteContent");
        }
        if (filename == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'filename' when calling deleteContent");
        }
        if (extension == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extension' when calling deleteContent");
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("folders", folders);
        pathParams.put("filename", filename);
        pathParams.put("extension", extension);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        ParameterizedTypeReference<FileResult> localVarReturnType = new ParameterizedTypeReference<FileResult>(){};
        return this.apiClient.invokeFluxAPI("/content/{client}/{folders}/{filename}.{extension}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<FileResult> deletePrivateContent(String client, String folders, String filename, String extension) throws RestClientException {
        Object postBody = null;
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deletePrivateContent");
        }
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling deletePrivateContent");
        }
        if (filename == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'filename' when calling deletePrivateContent");
        }
        if (extension == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extension' when calling deletePrivateContent");
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("folders", folders);
        pathParams.put("filename", filename);
        pathParams.put("extension", extension);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        ParameterizedTypeReference<FileResult> localVarReturnType = new ParameterizedTypeReference<FileResult>(){};
        return this.apiClient.invokeFluxAPI("/content/{client}/private/{folders}/{filename}.{extension}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Void> getContent(String client, String folders, String filename, String extension) throws RestClientException {
        Object postBody = null;
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getContent");
        }
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling getContent");
        }
        if (filename == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'filename' when calling getContent");
        }
        if (extension == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extension' when calling getContent");
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("folders", folders);
        pathParams.put("filename", filename);
        pathParams.put("extension", extension);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/content/{client}/{folders}/{filename}.{extension}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Void> getPrivateContent(String client, String folders, String filename, String extension) throws RestClientException {
        Object postBody = null;
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getPrivateContent");
        }
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling getPrivateContent");
        }
        if (filename == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'filename' when calling getPrivateContent");
        }
        if (extension == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extension' when calling getPrivateContent");
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("folders", folders);
        pathParams.put("filename", filename);
        pathParams.put("extension", extension);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/content/{client}/private/{folders}/{filename}.{extension}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<FileResult> getSignedToken(String client, String folders, String filename, String extension, String expires, String _public, String upload) throws RestClientException {
        Object postBody = null;
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getSignedToken");
        }
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling getSignedToken");
        }
        if (filename == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'filename' when calling getSignedToken");
        }
        if (extension == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extension' when calling getSignedToken");
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("folders", folders);
        pathParams.put("filename", filename);
        pathParams.put("extension", extension);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expires", expires));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "public", _public));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "upload", upload));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        ParameterizedTypeReference<FileResult> localVarReturnType = new ParameterizedTypeReference<FileResult>(){};
        return this.apiClient.invokeAPI("/content/{client}/signed/{folders}/{filename}.{extension}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<FileResult> listContent(String client, String folders) throws RestClientException {
        Object postBody = null;
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listContent");
        }
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling listContent");
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("folders", folders);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        ParameterizedTypeReference<FileResult> localVarReturnType = new ParameterizedTypeReference<FileResult>(){};
        return this.apiClient.invokeFluxAPI("/content/{client}/{folders}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<FileResult> listPrivateContent(String client, String folders, String recursive) throws RestClientException {
        Object postBody = null;
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listPrivateContent");
        }
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling listPrivateContent");
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("folders", folders);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "recursive", recursive));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        ParameterizedTypeReference<FileResult> localVarReturnType = new ParameterizedTypeReference<FileResult>(){};
        return this.apiClient.invokeFluxAPI("/content/{client}/private/{folders}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<FileResult> uploadContent(String client, String folders, String explode, String unique, File file) throws RestClientException {
        Object postBody = null;
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling uploadContent");
        }
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling uploadContent");
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("folders", folders);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "explode", explode));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "unique", unique));
        if (file != null) {
            formParams.add((Object)"file", (Object)new FileSystemResource(file));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        ParameterizedTypeReference<FileResult> localVarReturnType = new ParameterizedTypeReference<FileResult>(){};
        return this.apiClient.invokeFluxAPI("/content/{client}/{folders}/upload", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<FileResult> uploadPrivateContent(String client, String folders, String explode, String unique, File file) throws RestClientException {
        Object postBody = null;
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling uploadPrivateContent");
        }
        if (folders == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'folders' when calling uploadPrivateContent");
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("folders", folders);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "explode", explode));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "unique", unique));
        if (file != null) {
            formParams.add((Object)"file", (Object)new FileSystemResource(file));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api", "jwt", "oauth2"};
        ParameterizedTypeReference<FileResult> localVarReturnType = new ParameterizedTypeReference<FileResult>(){};
        return this.apiClient.invokeFluxAPI("/content/{client}/private/{folders}/upload", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

