/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.webflux.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * UpdateDataRequest
 */
@JsonPropertyOrder({
  UpdateDataRequest.JSON_PROPERTY_IDS,
  UpdateDataRequest.JSON_PROPERTY_SKIP_NULLS,
  UpdateDataRequest.JSON_PROPERTY_PROPERTIES,
  UpdateDataRequest.JSON_PROPERTY_CONTENT
})

public class UpdateDataRequest {
  public static final String JSON_PROPERTY_IDS = "ids";
  private List<String> ids = new ArrayList<>();

  public static final String JSON_PROPERTY_SKIP_NULLS = "skipNulls";
  private Boolean skipNulls;

  public static final String JSON_PROPERTY_PROPERTIES = "properties";
  private Map<String, Object> properties = null;

  public static final String JSON_PROPERTY_CONTENT = "content";
  private Map<String, Object> content = null;


  public UpdateDataRequest ids(List<String> ids) {
    
    this.ids = ids;
    return this;
  }

  public UpdateDataRequest addIdsItem(String idsItem) {
    this.ids.add(idsItem);
    return this;
  }

   /**
   * ID(s) to process
   * @return ids
  **/
  @ApiModelProperty(required = true, value = "ID(s) to process")
  @JsonProperty(JSON_PROPERTY_IDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getIds() {
    return ids;
  }


  public void setIds(List<String> ids) {
    this.ids = ids;
  }


  public UpdateDataRequest skipNulls(Boolean skipNulls) {
    
    this.skipNulls = skipNulls;
    return this;
  }

   /**
   * Ignore null values?
   * @return skipNulls
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Ignore null values?")
  @JsonProperty(JSON_PROPERTY_SKIP_NULLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSkipNulls() {
    return skipNulls;
  }


  public void setSkipNulls(Boolean skipNulls) {
    this.skipNulls = skipNulls;
  }


  public UpdateDataRequest properties(Map<String, Object> properties) {
    
    this.properties = properties;
    return this;
  }

  public UpdateDataRequest putPropertiesItem(String key, Object propertiesItem) {
    if (this.properties == null) {
      this.properties = new HashMap<>();
    }
    this.properties.put(key, propertiesItem);
    return this;
  }

   /**
   * User properties to update
   * @return properties
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "User properties to update")
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getProperties() {
    return properties;
  }


  public void setProperties(Map<String, Object> properties) {
    this.properties = properties;
  }


  public UpdateDataRequest content(Map<String, Object> content) {
    
    this.content = content;
    return this;
  }

  public UpdateDataRequest putContentItem(String key, Object contentItem) {
    if (this.content == null) {
      this.content = new HashMap<>();
    }
    this.content.put(key, contentItem);
    return this;
  }

   /**
   * Get content
   * @return content
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getContent() {
    return content;
  }


  public void setContent(Map<String, Object> content) {
    this.content = content;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateDataRequest updateDataRequest = (UpdateDataRequest) o;
    return Objects.equals(this.ids, updateDataRequest.ids) &&
        Objects.equals(this.skipNulls, updateDataRequest.skipNulls) &&
        Objects.equals(this.properties, updateDataRequest.properties) &&
        Objects.equals(this.content, updateDataRequest.content);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ids, skipNulls, properties, content);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateDataRequest {\n");
    sb.append("    ids: ").append(toIndentedString(ids)).append("\n");
    sb.append("    skipNulls: ").append(toIndentedString(skipNulls)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

