/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.webflux.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * OperationTargetResponse
 */
@JsonPropertyOrder({
  OperationTargetResponse.JSON_PROPERTY_ORIGIN,
  OperationTargetResponse.JSON_PROPERTY_TARGET,
  OperationTargetResponse.JSON_PROPERTY_SIZE,
  OperationTargetResponse.JSON_PROPERTY_PROPERTIES
})

public class OperationTargetResponse {
  public static final String JSON_PROPERTY_ORIGIN = "origin";
  private String origin;

  public static final String JSON_PROPERTY_TARGET = "target";
  private String target;

  public static final String JSON_PROPERTY_SIZE = "size";
  private Long size;

  public static final String JSON_PROPERTY_PROPERTIES = "properties";
  private Map<String, Object> properties = null;


   /**
   * Source to perform action on
   * @return origin
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Source to perform action on")
  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOrigin() {
    return origin;
  }




   /**
   * Action or target
   * @return target
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Action or target")
  @JsonProperty(JSON_PROPERTY_TARGET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTarget() {
    return target;
  }




   /**
   * Size (number of records, bytes, etc.
   * @return size
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Size (number of records, bytes, etc.")
  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSize() {
    return size;
  }




   /**
   * Resulting properties
   * @return properties
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Resulting properties")
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getProperties() {
    return properties;
  }




  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationTargetResponse operationTargetResponse = (OperationTargetResponse) o;
    return Objects.equals(this.origin, operationTargetResponse.origin) &&
        Objects.equals(this.target, operationTargetResponse.target) &&
        Objects.equals(this.size, operationTargetResponse.size) &&
        Objects.equals(this.properties, operationTargetResponse.properties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(origin, target, size, properties);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationTargetResponse {\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

