package io.logicdrop.openapi.webflux.api;

import io.logicdrop.openapi.webflux.ApiClient;

import io.logicdrop.openapi.webflux.models.ArtifactResponse;
import io.logicdrop.openapi.webflux.models.DeleteArtifactRequest;
import io.logicdrop.openapi.webflux.models.Template;
import io.logicdrop.openapi.webflux.models.UpdateArtifactRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;


public class TemplateServicesApi {
    private ApiClient apiClient;

    public TemplateServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public TemplateServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Delete template
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Template name
     * @param v Template version
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ArtifactResponse> deleteTemplate(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteTemplate");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deleteTemplate");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling deleteTemplate");
        }
        
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);


        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> returnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI("/templates/{client}/{project}/{artifact}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Delete templates
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param deleteArtifactRequest Remove templates by criteria
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ArtifactResponse> deleteTemplates(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws RestClientException {
        Object postBody = deleteArtifactRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteTemplates");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deleteTemplates");
        }
        
        // verify the required parameter 'deleteArtifactRequest' is set
        if (deleteArtifactRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deleteArtifactRequest' when calling deleteTemplates");
        }
        
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("project", project);


        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> returnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI("/templates/{client}/{project}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Get template
     * Get an template
     * <p><b>200</b> - Retrieved template
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param artifact Template name
     * @param v Template version
     * @param view Fields to return in the results
     * @return Template
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<Template> getTemplate(String client, String project, String artifact, String v, List<String> view) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getTemplate");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getTemplate");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getTemplate");
        }
        
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("project", project);
        pathParams.put("artifact", artifact);


        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<Template> returnType = new ParameterizedTypeReference<Template>() {};
        return apiClient.invokeAPI("/templates/{client}/{project}/{artifact}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * List templates
     * Get templates using optional simple filters
     * <p><b>200</b> - Retrieved templates
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param view Fields to return in the results
     * @return List&lt;Template&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Flux<Template> listTemplates(String client, String project, List<String> view) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listTemplates");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling listTemplates");
        }
        
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("project", project);


        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<Template> returnType = new ParameterizedTypeReference<Template>() {};
        return apiClient.invokeFluxAPI("/templates/{client}/{project}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Save template
     * Saves or creates a template (overwrite)
     * <p><b>200</b> - The saved template
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param template Template to persist
     * @return Template
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<Template> saveTemplate(String client, String project, Template template) throws RestClientException {
        Object postBody = template;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling saveTemplate");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling saveTemplate");
        }
        
        // verify the required parameter 'template' is set
        if (template == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'template' when calling saveTemplate");
        }
        
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("project", project);


        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<Template> returnType = new ParameterizedTypeReference<Template>() {};
        return apiClient.invokeAPI("/templates/{client}/{project}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Update template
     * Updates one template
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param updateArtifactRequest Templates to update
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ArtifactResponse> updateTemplate(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws RestClientException {
        Object postBody = updateArtifactRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateTemplate");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateTemplate");
        }
        
        // verify the required parameter 'updateArtifactRequest' is set
        if (updateArtifactRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateArtifactRequest' when calling updateTemplate");
        }
        
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("project", project);


        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> returnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI("/templates/{client}/{project}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Update templates
     * Updates multiple templates
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name
     * @param project Project name
     * @param updateArtifactRequest Templates to update
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<ArtifactResponse> updateTemplates(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws RestClientException {
        Object postBody = updateArtifactRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateTemplates");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateTemplates");
        }
        
        // verify the required parameter 'updateArtifactRequest' is set
        if (updateArtifactRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateArtifactRequest' when calling updateTemplates");
        }
        
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("client", client);
        pathParams.put("project", project);


        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> returnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI("/templates/{client}/{project}", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
}
