package io.logicdrop.openapi.webflux.api;

import io.logicdrop.openapi.webflux.ApiClient;

import io.logicdrop.openapi.webflux.models.OperationRequest;
import io.logicdrop.openapi.webflux.models.OperationResponse;
import io.logicdrop.openapi.webflux.models.OperationTargetResponse;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;


public class PlatformServicesApi {
    private ApiClient apiClient;

    public PlatformServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public PlatformServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * List managed services
     * Get manges targets
     * <p><b>200</b> - Retrieved targets
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param service Service
     * @param operationRequest Operation request
     * @param data Include data
     * @return List&lt;OperationTargetResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Flux<OperationTargetResponse> listManagedServices(String service, OperationRequest operationRequest, String data) throws RestClientException {
        Object postBody = operationRequest;
        
        // verify the required parameter 'service' is set
        if (service == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'service' when calling listManagedServices");
        }
        
        // verify the required parameter 'operationRequest' is set
        if (operationRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'operationRequest' when calling listManagedServices");
        }
        
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("service", service);


        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "data", data));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<OperationTargetResponse> returnType = new ParameterizedTypeReference<OperationTargetResponse>() {};
        return apiClient.invokeFluxAPI("/manage/{service}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Manage service
     * Perform managed operation
     * <p><b>200</b> - Operations response
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param service Service
     * @param operationRequest Operation request
     * @return OperationResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<OperationResponse> manageService(String service, OperationRequest operationRequest) throws RestClientException {
        Object postBody = operationRequest;
        
        // verify the required parameter 'service' is set
        if (service == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'service' when calling manageService");
        }
        
        // verify the required parameter 'operationRequest' is set
        if (operationRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'operationRequest' when calling manageService");
        }
        
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("service", service);


        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<OperationResponse> returnType = new ParameterizedTypeReference<OperationResponse>() {};
        return apiClient.invokeAPI("/manage/{service}", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Platform details
     * Retrieve information
     * <p><b>200</b> - OK
     * <p><b>400</b> - Bad request
     * <p><b>500</b> - Backend Error
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Mono<Void> platformInfo() throws RestClientException {
        Object postBody = null;
        
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();


        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] accepts = { };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<Void> returnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/info", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
}
