package io.logicdrop.openapi.spring.api;

import io.logicdrop.openapi.spring.ApiClient;

import io.logicdrop.openapi.models.PipelineMessage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;


@Component("io.logicdrop.openapi.spring.api.PipelineServicesApi")
public class PipelineServicesApi {
    private ApiClient apiClient;

    public PipelineServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public PipelineServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Execute pipeline
     * Executes a pipeline
     * <p><b>200</b> - Pipeline response
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param route Route (required)
     * @param pipelineMessage Pipeline request (required)
     * @return PipelineMessage
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public PipelineMessage executePipeline(String client, String route, PipelineMessage pipelineMessage) throws RestClientException {
        return executePipelineWithHttpInfo(client, route, pipelineMessage).getBody();
    }

    /**
     * Execute pipeline
     * Executes a pipeline
     * <p><b>200</b> - Pipeline response
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param route Route (required)
     * @param pipelineMessage Pipeline request (required)
     * @return ResponseEntity&lt;PipelineMessage&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<PipelineMessage> executePipelineWithHttpInfo(String client, String route, PipelineMessage pipelineMessage) throws RestClientException {
        Object postBody = pipelineMessage;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling executePipeline");
        }
        
        // verify the required parameter 'route' is set
        if (route == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'route' when calling executePipeline");
        }
        
        // verify the required parameter 'pipelineMessage' is set
        if (pipelineMessage == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pipelineMessage' when calling executePipeline");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("route", route);
        String path = apiClient.expandPath("/pipeline/{client}/{route}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "*/*"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<PipelineMessage> returnType = new ParameterizedTypeReference<PipelineMessage>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
}
