/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.spring.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * UpdateArtifactRequest
 */
@JsonPropertyOrder({
  UpdateArtifactRequest.JSON_PROPERTY_IDS,
  UpdateArtifactRequest.JSON_PROPERTY_NAME,
  UpdateArtifactRequest.JSON_PROPERTY_DESCRIPTION,
  UpdateArtifactRequest.JSON_PROPERTY_TAGS,
  UpdateArtifactRequest.JSON_PROPERTY_PROPERTIES,
  UpdateArtifactRequest.JSON_PROPERTY_CONTENT
})

public class UpdateArtifactRequest {
  public static final String JSON_PROPERTY_IDS = "ids";
  private List<String> ids = new ArrayList<>();

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<String> tags = null;

  public static final String JSON_PROPERTY_PROPERTIES = "properties";
  private Map<String, Object> properties = null;

  public static final String JSON_PROPERTY_CONTENT = "content";
  private Map<String, Object> content = null;


  public UpdateArtifactRequest ids(List<String> ids) {
    
    this.ids = ids;
    return this;
  }

  public UpdateArtifactRequest addIdsItem(String idsItem) {
    this.ids.add(idsItem);
    return this;
  }

   /**
   * ID(s) to process
   * @return ids
  **/
  @ApiModelProperty(required = true, value = "ID(s) to process")
  @JsonProperty(JSON_PROPERTY_IDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getIds() {
    return ids;
  }


  public void setIds(List<String> ids) {
    this.ids = ids;
  }


  public UpdateArtifactRequest name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name to update
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Name to update")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public UpdateArtifactRequest description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Description to update
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Description to update")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public UpdateArtifactRequest tags(List<String> tags) {
    
    this.tags = tags;
    return this;
  }

  public UpdateArtifactRequest addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Tags to update
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Tags to update")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getTags() {
    return tags;
  }


  public void setTags(List<String> tags) {
    this.tags = tags;
  }


  public UpdateArtifactRequest properties(Map<String, Object> properties) {
    
    this.properties = properties;
    return this;
  }

  public UpdateArtifactRequest putPropertiesItem(String key, Object propertiesItem) {
    if (this.properties == null) {
      this.properties = new HashMap<>();
    }
    this.properties.put(key, propertiesItem);
    return this;
  }

   /**
   * User properties to update
   * @return properties
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "User properties to update")
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getProperties() {
    return properties;
  }


  public void setProperties(Map<String, Object> properties) {
    this.properties = properties;
  }


  public UpdateArtifactRequest content(Map<String, Object> content) {
    
    this.content = content;
    return this;
  }

  public UpdateArtifactRequest putContentItem(String key, Object contentItem) {
    if (this.content == null) {
      this.content = new HashMap<>();
    }
    this.content.put(key, contentItem);
    return this;
  }

   /**
   * Get content
   * @return content
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getContent() {
    return content;
  }


  public void setContent(Map<String, Object> content) {
    this.content = content;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateArtifactRequest updateArtifactRequest = (UpdateArtifactRequest) o;
    return Objects.equals(this.ids, updateArtifactRequest.ids) &&
        Objects.equals(this.name, updateArtifactRequest.name) &&
        Objects.equals(this.description, updateArtifactRequest.description) &&
        Objects.equals(this.tags, updateArtifactRequest.tags) &&
        Objects.equals(this.properties, updateArtifactRequest.properties) &&
        Objects.equals(this.content, updateArtifactRequest.content);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ids, name, description, tags, properties, content);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateArtifactRequest {\n");
    sb.append("    ids: ").append(toIndentedString(ids)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

