/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.spring.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * OperationResponse
 */
@JsonPropertyOrder({
  OperationResponse.JSON_PROPERTY_ACTION,
  OperationResponse.JSON_PROPERTY_STATUS,
  OperationResponse.JSON_PROPERTY_MESSAGE,
  OperationResponse.JSON_PROPERTY_SIZE,
  OperationResponse.JSON_PROPERTY_RESULT
})

public class OperationResponse {
  public static final String JSON_PROPERTY_ACTION = "action";
  private String action;

  /**
   * Action status
   */
  public enum StatusEnum {
    OK("OK"),
    
    CREATED("Created"),
    
    ACCEPTED("Accepted"),
    
    NO_CONTENT("No Content"),
    
    RESET_CONTENT("Reset Content"),
    
    PARTIAL_CONTENT("Partial Content"),
    
    MOVED_PERMANENTLY("Moved Permanently"),
    
    FOUND("Found"),
    
    SEE_OTHER("See Other"),
    
    NOT_MODIFIED("Not Modified"),
    
    USE_PROXY("Use Proxy"),
    
    TEMPORARY_REDIRECT("Temporary Redirect"),
    
    BAD_REQUEST("Bad Request"),
    
    UNAUTHORIZED("Unauthorized"),
    
    PAYMENT_REQUIRED("Payment Required"),
    
    FORBIDDEN("Forbidden"),
    
    NOT_FOUND("Not Found"),
    
    METHOD_NOT_ALLOWED("Method Not Allowed"),
    
    NOT_ACCEPTABLE("Not Acceptable"),
    
    PROXY_AUTHENTICATION_REQUIRED("Proxy Authentication Required"),
    
    REQUEST_TIMEOUT("Request Timeout"),
    
    CONFLICT("Conflict"),
    
    GONE("Gone"),
    
    LENGTH_REQUIRED("Length Required"),
    
    PRECONDITION_FAILED("Precondition Failed"),
    
    REQUEST_ENTITY_TOO_LARGE("Request Entity Too Large"),
    
    REQUEST_URI_TOO_LONG("Request-URI Too Long"),
    
    UNSUPPORTED_MEDIA_TYPE("Unsupported Media Type"),
    
    REQUESTED_RANGE_NOT_SATISFIABLE("Requested Range Not Satisfiable"),
    
    EXPECTATION_FAILED("Expectation Failed"),
    
    PRECONDITION_REQUIRED("Precondition Required"),
    
    TOO_MANY_REQUESTS("Too Many Requests"),
    
    REQUEST_HEADER_FIELDS_TOO_LARGE("Request Header Fields Too Large"),
    
    INTERNAL_SERVER_ERROR("Internal Server Error"),
    
    NOT_IMPLEMENTED("Not Implemented"),
    
    BAD_GATEWAY("Bad Gateway"),
    
    SERVICE_UNAVAILABLE("Service Unavailable"),
    
    GATEWAY_TIMEOUT("Gateway Timeout"),
    
    HTTP_VERSION_NOT_SUPPORTED("HTTP Version Not Supported"),
    
    NETWORK_AUTHENTICATION_REQUIRED("Network Authentication Required");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public static final String JSON_PROPERTY_SIZE = "size";
  private Long size;

  public static final String JSON_PROPERTY_RESULT = "result";
  private Object result;


   /**
   * Action performed
   * @return action
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Action performed")
  @JsonProperty(JSON_PROPERTY_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAction() {
    return action;
  }




   /**
   * Action status
   * @return status
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Action status")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }




   /**
   * Action message
   * @return message
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Action message")
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessage() {
    return message;
  }




   /**
   * Size (number of records, bytes, etc.
   * @return size
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Size (number of records, bytes, etc.")
  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSize() {
    return size;
  }




   /**
   * Action result
   * @return result
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Action result")
  @JsonProperty(JSON_PROPERTY_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getResult() {
    return result;
  }




  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationResponse operationResponse = (OperationResponse) o;
    return Objects.equals(this.action, operationResponse.action) &&
        Objects.equals(this.status, operationResponse.status) &&
        Objects.equals(this.message, operationResponse.message) &&
        Objects.equals(this.size, operationResponse.size) &&
        Objects.equals(this.result, operationResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(action, status, message, size, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationResponse {\n");
    sb.append("    action: ").append(toIndentedString(action)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

