/*
 * Sparks OpenAPI
 * Generated documentation for the Logicdrop Sparks API and OpenAPI clients.  Logicdrop Sparks lets users build rules, analyze data, and automate documents.  Use it to make decisions faster, generate documents better, and learn from your data.  ### Documentation - [User Documentation](https://docs.logicdrop.com)  ### Modules - [Sparks Compute](https://docs.logicdrop.com/rules/introduction) - [Sparks Decision Tables](https://docs.logicdrop.com/rules/authoring-decision-tables) - [Sparks Documents](https://docs.logicdrop.com/documents/introduction)  ### Clients - [OpenAPI Clients](https://docs.logicdrop.com/development/sample-clients)  ### Security - [Authorizing API Requests](https://docs.logicdrop.com/development/authorization) 
 *
 * The version of the OpenAPI document: v_VERSION_, build# _BUILD_
 * Contact: support@logicdrop.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.logicdrop.openapi.spring.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * GenerateRulesRequest
 */
@JsonPropertyOrder({
  GenerateRulesRequest.JSON_PROPERTY_RULESET,
  GenerateRulesRequest.JSON_PROPERTY_PROJECT,
  GenerateRulesRequest.JSON_PROPERTY_VERSION,
  GenerateRulesRequest.JSON_PROPERTY_CONTENT,
  GenerateRulesRequest.JSON_PROPERTY_RULES
})

public class GenerateRulesRequest {
  public static final String JSON_PROPERTY_RULESET = "ruleset";
  private String ruleset;

  public static final String JSON_PROPERTY_PROJECT = "project";
  private String project;

  public static final String JSON_PROPERTY_VERSION = "version";
  private String version;

  public static final String JSON_PROPERTY_CONTENT = "content";
  private Boolean content;

  public static final String JSON_PROPERTY_RULES = "rules";
  private List<String> rules = new ArrayList<>();


  public GenerateRulesRequest ruleset(String ruleset) {
    
    this.ruleset = ruleset;
    return this;
  }

   /**
   * Ruleset name
   * @return ruleset
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Ruleset name")
  @JsonProperty(JSON_PROPERTY_RULESET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRuleset() {
    return ruleset;
  }


  public void setRuleset(String ruleset) {
    this.ruleset = ruleset;
  }


  public GenerateRulesRequest project(String project) {
    
    this.project = project;
    return this;
  }

   /**
   * Project name
   * @return project
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Project name")
  @JsonProperty(JSON_PROPERTY_PROJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProject() {
    return project;
  }


  public void setProject(String project) {
    this.project = project;
  }


  public GenerateRulesRequest version(String version) {
    
    this.version = version;
    return this;
  }

   /**
   * Ruleset version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Ruleset version")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersion() {
    return version;
  }


  public void setVersion(String version) {
    this.version = version;
  }


  public GenerateRulesRequest content(Boolean content) {
    
    this.content = content;
    return this;
  }

   /**
   * Include content?
   * @return content
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Include content?")
  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getContent() {
    return content;
  }


  public void setContent(Boolean content) {
    this.content = content;
  }


  public GenerateRulesRequest rules(List<String> rules) {
    
    this.rules = rules;
    return this;
  }

  public GenerateRulesRequest addRulesItem(String rulesItem) {
    this.rules.add(rulesItem);
    return this;
  }

   /**
   * Rule IDs to process
   * @return rules
  **/
  @ApiModelProperty(required = true, value = "Rule IDs to process")
  @JsonProperty(JSON_PROPERTY_RULES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getRules() {
    return rules;
  }


  public void setRules(List<String> rules) {
    this.rules = rules;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GenerateRulesRequest generateRulesRequest = (GenerateRulesRequest) o;
    return Objects.equals(this.ruleset, generateRulesRequest.ruleset) &&
        Objects.equals(this.project, generateRulesRequest.project) &&
        Objects.equals(this.version, generateRulesRequest.version) &&
        Objects.equals(this.content, generateRulesRequest.content) &&
        Objects.equals(this.rules, generateRulesRequest.rules);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ruleset, project, version, content, rules);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GenerateRulesRequest {\n");
    sb.append("    ruleset: ").append(toIndentedString(ruleset)).append("\n");
    sb.append("    project: ").append(toIndentedString(project)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    rules: ").append(toIndentedString(rules)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

