package io.logicdrop.openapi.spring.api;

import io.logicdrop.openapi.spring.ApiClient;

import io.logicdrop.openapi.spring.models.ArtifactResponse;
import io.logicdrop.openapi.spring.models.DataResponse;
import io.logicdrop.openapi.spring.models.Dataset;
import io.logicdrop.openapi.spring.models.DeleteArtifactRequest;
import io.logicdrop.openapi.spring.models.DeleteDataRequest;
import io.logicdrop.openapi.spring.models.ExternalSource;
import java.io.File;
import io.logicdrop.openapi.spring.models.SaveContentRequest;
import io.logicdrop.openapi.spring.models.UpdateArtifactRequest;
import io.logicdrop.openapi.spring.models.UpdateDataRequest;
import io.logicdrop.openapi.spring.models.UploadResponse;
import io.logicdrop.openapi.spring.models.UserData;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;


@Component("io.logicdrop.openapi.spring.api.DataServicesApi")
public class DataServicesApi {
    private ApiClient apiClient;

    public DataServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public DataServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Delete dataset
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param v Dataset version (optional)
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ArtifactResponse deleteDataset(String client, String project, String artifact, String v) throws RestClientException {
        return deleteDatasetWithHttpInfo(client, project, artifact, v).getBody();
    }

    /**
     * Delete dataset
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param v Dataset version (optional)
     * @return ResponseEntity&lt;ArtifactResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ArtifactResponse> deleteDatasetWithHttpInfo(String client, String project, String artifact, String v) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteDataset");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deleteDataset");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling deleteDataset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/data/{client}/{project}/{artifact}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> returnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.DELETE, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Delete datasets
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param deleteArtifactRequest Remove datasets by criteria (required)
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ArtifactResponse deleteDatasets(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws RestClientException {
        return deleteDatasetsWithHttpInfo(client, project, deleteArtifactRequest).getBody();
    }

    /**
     * Delete datasets
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param deleteArtifactRequest Remove datasets by criteria (required)
     * @return ResponseEntity&lt;ArtifactResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ArtifactResponse> deleteDatasetsWithHttpInfo(String client, String project, DeleteArtifactRequest deleteArtifactRequest) throws RestClientException {
        Object postBody = deleteArtifactRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteDatasets");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deleteDatasets");
        }
        
        // verify the required parameter 'deleteArtifactRequest' is set
        if (deleteArtifactRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deleteArtifactRequest' when calling deleteDatasets");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        String path = apiClient.expandPath("/data/{client}/{project}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> returnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.DELETE, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Delete record
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param id Record Id (required)
     * @param v Dataset version (optional)
     * @return DataResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DataResponse deleteRecord(String client, String project, String artifact, String id, String v) throws RestClientException {
        return deleteRecordWithHttpInfo(client, project, artifact, id, v).getBody();
    }

    /**
     * Delete record
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param id Record Id (required)
     * @param v Dataset version (optional)
     * @return ResponseEntity&lt;DataResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DataResponse> deleteRecordWithHttpInfo(String client, String project, String artifact, String id, String v) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteRecord");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deleteRecord");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling deleteRecord");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling deleteRecord");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        uriVariables.put("id", id);
        String path = apiClient.expandPath("/data/{client}/{project}/{artifact}/rows/{id}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<DataResponse> returnType = new ParameterizedTypeReference<DataResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.DELETE, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Delete records
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param deleteDataRequest Remove records by criteria (required)
     * @param v Dataset version (optional)
     * @return DataResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DataResponse deleteRecords(String client, String project, String artifact, DeleteDataRequest deleteDataRequest, String v) throws RestClientException {
        return deleteRecordsWithHttpInfo(client, project, artifact, deleteDataRequest, v).getBody();
    }

    /**
     * Delete records
     * 
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param deleteDataRequest Remove records by criteria (required)
     * @param v Dataset version (optional)
     * @return ResponseEntity&lt;DataResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DataResponse> deleteRecordsWithHttpInfo(String client, String project, String artifact, DeleteDataRequest deleteDataRequest, String v) throws RestClientException {
        Object postBody = deleteDataRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling deleteRecords");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling deleteRecords");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling deleteRecords");
        }
        
        // verify the required parameter 'deleteDataRequest' is set
        if (deleteDataRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deleteDataRequest' when calling deleteRecords");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/data/{client}/{project}/{artifact}/rows", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<DataResponse> returnType = new ParameterizedTypeReference<DataResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.DELETE, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Get dataset
     * Get a dataset
     * <p><b>200</b> - Retrieved dataset
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param v Dataset version (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return Dataset
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Dataset getDataset(String client, String project, String artifact, String v, List<String> view) throws RestClientException {
        return getDatasetWithHttpInfo(client, project, artifact, v, view).getBody();
    }

    /**
     * Get dataset
     * Get a dataset
     * <p><b>200</b> - Retrieved dataset
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param v Dataset version (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return ResponseEntity&lt;Dataset&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Dataset> getDatasetWithHttpInfo(String client, String project, String artifact, String v, List<String> view) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getDataset");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getDataset");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getDataset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/data/{client}/{project}/{artifact}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<Dataset> returnType = new ParameterizedTypeReference<Dataset>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Get content
     * Get dataset content using optional simple filters
     * <p><b>200</b> - Retrieved content
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param v Dataset version (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return Object
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Object getDatasetContent(String client, String project, String artifact, String v, List<String> view) throws RestClientException {
        return getDatasetContentWithHttpInfo(client, project, artifact, v, view).getBody();
    }

    /**
     * Get content
     * Get dataset content using optional simple filters
     * <p><b>200</b> - Retrieved content
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param v Dataset version (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return ResponseEntity&lt;Object&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Object> getDatasetContentWithHttpInfo(String client, String project, String artifact, String v, List<String> view) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getDatasetContent");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getDatasetContent");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getDatasetContent");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/data/{client}/{project}/{artifact}/content", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<Object> returnType = new ParameterizedTypeReference<Object>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Get record
     * Get a record
     * <p><b>200</b> - Retrieved record
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param id Record Id (required)
     * @param v Dataset version (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return UserData
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public UserData getRecord(String client, String project, String artifact, String id, String v, List<String> view) throws RestClientException {
        return getRecordWithHttpInfo(client, project, artifact, id, v, view).getBody();
    }

    /**
     * Get record
     * Get a record
     * <p><b>200</b> - Retrieved record
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param id Record Id (required)
     * @param v Dataset version (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return ResponseEntity&lt;UserData&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<UserData> getRecordWithHttpInfo(String client, String project, String artifact, String id, String v, List<String> view) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling getRecord");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling getRecord");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling getRecord");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getRecord");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        uriVariables.put("id", id);
        String path = apiClient.expandPath("/data/{client}/{project}/{artifact}/rows/{id}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<UserData> returnType = new ParameterizedTypeReference<UserData>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * List datasets
     * Get datasets using optional simple filters
     * <p><b>200</b> - Retrieved datasets
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return List&lt;Dataset&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<Dataset> listDatasets(String client, String project, List<String> view) throws RestClientException {
        return listDatasetsWithHttpInfo(client, project, view).getBody();
    }

    /**
     * List datasets
     * Get datasets using optional simple filters
     * <p><b>200</b> - Retrieved datasets
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return ResponseEntity&lt;List&lt;Dataset&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<Dataset>> listDatasetsWithHttpInfo(String client, String project, List<String> view) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listDatasets");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling listDatasets");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        String path = apiClient.expandPath("/data/{client}/{project}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<Dataset>> returnType = new ParameterizedTypeReference<List<Dataset>>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * List records
     * Get records using optional simple filters
     * <p><b>200</b> - Retrieved records
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param v Dataset version (optional)
     * @param criteria SQL-like query (optional)
     * @param fields Any fields that match the single value only (requires a value) (optional, default to new ArrayList&lt;&gt;())
     * @param value Value to find in any fields (requires fields) (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @param filter Filters to apply (optional, default to new ArrayList&lt;&gt;())
     * @param order Fields to order by (field:asc|desc) (optional, default to new ArrayList&lt;&gt;())
     * @param tags Tags to filter by (optional, default to new ArrayList&lt;&gt;())
     * @param ignoreCase Ignore case (optional, default to false)
     * @param limit Limit result size (optional, default to 0)
     * @return List&lt;UserData&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<UserData> listRecords(String client, String project, String artifact, String v, String criteria, List<String> fields, String value, List<String> view, List<String> filter, List<String> order, List<String> tags, Boolean ignoreCase, Integer limit) throws RestClientException {
        return listRecordsWithHttpInfo(client, project, artifact, v, criteria, fields, value, view, filter, order, tags, ignoreCase, limit).getBody();
    }

    /**
     * List records
     * Get records using optional simple filters
     * <p><b>200</b> - Retrieved records
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param v Dataset version (optional)
     * @param criteria SQL-like query (optional)
     * @param fields Any fields that match the single value only (requires a value) (optional, default to new ArrayList&lt;&gt;())
     * @param value Value to find in any fields (requires fields) (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @param filter Filters to apply (optional, default to new ArrayList&lt;&gt;())
     * @param order Fields to order by (field:asc|desc) (optional, default to new ArrayList&lt;&gt;())
     * @param tags Tags to filter by (optional, default to new ArrayList&lt;&gt;())
     * @param ignoreCase Ignore case (optional, default to false)
     * @param limit Limit result size (optional, default to 0)
     * @return ResponseEntity&lt;List&lt;UserData&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<UserData>> listRecordsWithHttpInfo(String client, String project, String artifact, String v, String criteria, List<String> fields, String value, List<String> view, List<String> filter, List<String> order, List<String> tags, Boolean ignoreCase, Integer limit) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listRecords");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling listRecords");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling listRecords");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/data/{client}/{project}/{artifact}/rows", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "value", value));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "filter", filter));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "order", order));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "tags", tags));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "ignoreCase", ignoreCase));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<UserData>> returnType = new ParameterizedTypeReference<List<UserData>>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * List records by key
     * Get records using a single key/value
     * <p><b>200</b> - Retrieved record(s)
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param key Field name (required)
     * @param value Field value (required)
     * @param v Dataset version (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return List&lt;UserData&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<UserData> listRecordsByKey(String client, String project, String artifact, String key, String value, String v, List<String> view) throws RestClientException {
        return listRecordsByKeyWithHttpInfo(client, project, artifact, key, value, v, view).getBody();
    }

    /**
     * List records by key
     * Get records using a single key/value
     * <p><b>200</b> - Retrieved record(s)
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param key Field name (required)
     * @param value Field value (required)
     * @param v Dataset version (optional)
     * @param view Fields to return in the results (optional, default to new ArrayList&lt;&gt;())
     * @return ResponseEntity&lt;List&lt;UserData&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<UserData>> listRecordsByKeyWithHttpInfo(String client, String project, String artifact, String key, String value, String v, List<String> view) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listRecordsByKey");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling listRecordsByKey");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling listRecordsByKey");
        }
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'key' when calling listRecordsByKey");
        }
        
        // verify the required parameter 'value' is set
        if (value == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'value' when calling listRecordsByKey");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        uriVariables.put("key", key);
        uriVariables.put("value", value);
        String path = apiClient.expandPath("/data/{client}/{project}/{artifact}/rows/{key}/{value}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "view", view));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<UserData>> returnType = new ParameterizedTypeReference<List<UserData>>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * List external sources
     * Get available external sources or check if a source exists
     * <p><b>200</b> - Retrieved external sources
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param check Check if source name exists? (optional)
     * @return List&lt;ExternalSource&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<ExternalSource> listSources(String client, String check) throws RestClientException {
        return listSourcesWithHttpInfo(client, check).getBody();
    }

    /**
     * List external sources
     * Get available external sources or check if a source exists
     * <p><b>200</b> - Retrieved external sources
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param check Check if source name exists? (optional)
     * @return ResponseEntity&lt;List&lt;ExternalSource&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<ExternalSource>> listSourcesWithHttpInfo(String client, String check) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling listSources");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        String path = apiClient.expandPath("/data/{client}/sources", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "check", check));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<List<ExternalSource>> returnType = new ParameterizedTypeReference<List<ExternalSource>>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Save dataset
     * Saves or creates an dataset (overwrite)
     * <p><b>200</b> - The saved dataset
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param dataset Dataset to persist (required)
     * @return Dataset
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Dataset saveDataset(String client, String project, Dataset dataset) throws RestClientException {
        return saveDatasetWithHttpInfo(client, project, dataset).getBody();
    }

    /**
     * Save dataset
     * Saves or creates an dataset (overwrite)
     * <p><b>200</b> - The saved dataset
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param dataset Dataset to persist (required)
     * @return ResponseEntity&lt;Dataset&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Dataset> saveDatasetWithHttpInfo(String client, String project, Dataset dataset) throws RestClientException {
        Object postBody = dataset;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling saveDataset");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling saveDataset");
        }
        
        // verify the required parameter 'dataset' is set
        if (dataset == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'dataset' when calling saveDataset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        String path = apiClient.expandPath("/data/{client}/{project}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<Dataset> returnType = new ParameterizedTypeReference<Dataset>() {};
        return apiClient.invokeAPI(path, HttpMethod.PUT, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Save content
     * Save dataset content
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param saveContentRequest Content to persist (required)
     * @param v Dataset version (optional)
     * @return Object
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Object saveDatasetContent(String client, String project, String artifact, SaveContentRequest saveContentRequest, String v) throws RestClientException {
        return saveDatasetContentWithHttpInfo(client, project, artifact, saveContentRequest, v).getBody();
    }

    /**
     * Save content
     * Save dataset content
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param saveContentRequest Content to persist (required)
     * @param v Dataset version (optional)
     * @return ResponseEntity&lt;Object&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Object> saveDatasetContentWithHttpInfo(String client, String project, String artifact, SaveContentRequest saveContentRequest, String v) throws RestClientException {
        Object postBody = saveContentRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling saveDatasetContent");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling saveDatasetContent");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling saveDatasetContent");
        }
        
        // verify the required parameter 'saveContentRequest' is set
        if (saveContentRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'saveContentRequest' when calling saveDatasetContent");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/data/{client}/{project}/{artifact}/content", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<Object> returnType = new ParameterizedTypeReference<Object>() {};
        return apiClient.invokeAPI(path, HttpMethod.PUT, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Save record
     * Saves or create a record (overwrite)
     * <p><b>200</b> - The saved record
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param requestBody Record to persist (required)
     * @param v Dataset version (optional)
     * @return UserData
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public UserData saveRecord(String client, String project, String artifact, Map<String, Object> requestBody, String v) throws RestClientException {
        return saveRecordWithHttpInfo(client, project, artifact, requestBody, v).getBody();
    }

    /**
     * Save record
     * Saves or create a record (overwrite)
     * <p><b>200</b> - The saved record
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param requestBody Record to persist (required)
     * @param v Dataset version (optional)
     * @return ResponseEntity&lt;UserData&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<UserData> saveRecordWithHttpInfo(String client, String project, String artifact, Map<String, Object> requestBody, String v) throws RestClientException {
        Object postBody = requestBody;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling saveRecord");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling saveRecord");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling saveRecord");
        }
        
        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'requestBody' when calling saveRecord");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/data/{client}/{project}/{artifact}/rows", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<UserData> returnType = new ParameterizedTypeReference<UserData>() {};
        return apiClient.invokeAPI(path, HttpMethod.PUT, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Update dataset
     * Updates one dataset
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param updateArtifactRequest Dataset to update (required)
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ArtifactResponse updateDataset(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws RestClientException {
        return updateDatasetWithHttpInfo(client, project, updateArtifactRequest).getBody();
    }

    /**
     * Update dataset
     * Updates one dataset
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param updateArtifactRequest Dataset to update (required)
     * @return ResponseEntity&lt;ArtifactResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ArtifactResponse> updateDatasetWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws RestClientException {
        Object postBody = updateArtifactRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateDataset");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateDataset");
        }
        
        // verify the required parameter 'updateArtifactRequest' is set
        if (updateArtifactRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateArtifactRequest' when calling updateDataset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        String path = apiClient.expandPath("/data/{client}/{project}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> returnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.PATCH, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Update content
     * Update dataset content
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param updateDataRequest Records to transform (required)
     * @param v Dataset version (optional)
     * @return Object
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Object updateDatasetContent(String client, String project, String artifact, UpdateDataRequest updateDataRequest, String v) throws RestClientException {
        return updateDatasetContentWithHttpInfo(client, project, artifact, updateDataRequest, v).getBody();
    }

    /**
     * Update content
     * Update dataset content
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param updateDataRequest Records to transform (required)
     * @param v Dataset version (optional)
     * @return ResponseEntity&lt;Object&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Object> updateDatasetContentWithHttpInfo(String client, String project, String artifact, UpdateDataRequest updateDataRequest, String v) throws RestClientException {
        Object postBody = updateDataRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateDatasetContent");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateDatasetContent");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling updateDatasetContent");
        }
        
        // verify the required parameter 'updateDataRequest' is set
        if (updateDataRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateDataRequest' when calling updateDatasetContent");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/data/{client}/{project}/{artifact}/content", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<Object> returnType = new ParameterizedTypeReference<Object>() {};
        return apiClient.invokeAPI(path, HttpMethod.PATCH, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Update content item
     * Update dataset content item
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param index Index or property to save at (required)
     * @param updateDataRequest Content to persist at key (required)
     * @param v Dataset version (optional)
     * @return Object
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Object updateDatasetContentAt(String client, String project, String artifact, String index, UpdateDataRequest updateDataRequest, String v) throws RestClientException {
        return updateDatasetContentAtWithHttpInfo(client, project, artifact, index, updateDataRequest, v).getBody();
    }

    /**
     * Update content item
     * Update dataset content item
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param index Index or property to save at (required)
     * @param updateDataRequest Content to persist at key (required)
     * @param v Dataset version (optional)
     * @return ResponseEntity&lt;Object&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Object> updateDatasetContentAtWithHttpInfo(String client, String project, String artifact, String index, UpdateDataRequest updateDataRequest, String v) throws RestClientException {
        Object postBody = updateDataRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateDatasetContentAt");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateDatasetContentAt");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling updateDatasetContentAt");
        }
        
        // verify the required parameter 'index' is set
        if (index == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'index' when calling updateDatasetContentAt");
        }
        
        // verify the required parameter 'updateDataRequest' is set
        if (updateDataRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateDataRequest' when calling updateDatasetContentAt");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        uriVariables.put("index", index);
        String path = apiClient.expandPath("/data/{client}/{project}/{artifact}/content/{index}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<Object> returnType = new ParameterizedTypeReference<Object>() {};
        return apiClient.invokeAPI(path, HttpMethod.PATCH, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Update datasets
     * Updates multiple datasets
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param updateArtifactRequest Datasets to update (required)
     * @return ArtifactResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ArtifactResponse updateDatasets(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws RestClientException {
        return updateDatasetsWithHttpInfo(client, project, updateArtifactRequest).getBody();
    }

    /**
     * Update datasets
     * Updates multiple datasets
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param updateArtifactRequest Datasets to update (required)
     * @return ResponseEntity&lt;ArtifactResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ArtifactResponse> updateDatasetsWithHttpInfo(String client, String project, UpdateArtifactRequest updateArtifactRequest) throws RestClientException {
        Object postBody = updateArtifactRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateDatasets");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateDatasets");
        }
        
        // verify the required parameter 'updateArtifactRequest' is set
        if (updateArtifactRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateArtifactRequest' when calling updateDatasets");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        String path = apiClient.expandPath("/data/{client}/{project}", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<ArtifactResponse> returnType = new ParameterizedTypeReference<ArtifactResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Update records
     * Updates existing records (overwrite)
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param updateDataRequest Records to update (required)
     * @param v Dataset version (optional)
     * @return DataResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DataResponse updateRecords(String client, String project, String artifact, UpdateDataRequest updateDataRequest, String v) throws RestClientException {
        return updateRecordsWithHttpInfo(client, project, artifact, updateDataRequest, v).getBody();
    }

    /**
     * Update records
     * Updates existing records (overwrite)
     * <p><b>200</b> - Results of the operation
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>404</b> - Not found
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param updateDataRequest Records to update (required)
     * @param v Dataset version (optional)
     * @return ResponseEntity&lt;DataResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DataResponse> updateRecordsWithHttpInfo(String client, String project, String artifact, UpdateDataRequest updateDataRequest, String v) throws RestClientException {
        Object postBody = updateDataRequest;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling updateRecords");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling updateRecords");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling updateRecords");
        }
        
        // verify the required parameter 'updateDataRequest' is set
        if (updateDataRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateDataRequest' when calling updateRecords");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/data/{client}/{project}/{artifact}/rows", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<DataResponse> returnType = new ParameterizedTypeReference<DataResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.PATCH, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Import datasets
     * Import datasets
     * <p><b>200</b> - The imported result
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param identity Unique row identifier (key) (required)
     * @param v Dataset version (optional)
     * @param external Document or collection (optional)
     * @param file File (optional)
     * @return UploadResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public UploadResponse uploadDataset(String client, String project, String artifact, String identity, String v, String external, File file) throws RestClientException {
        return uploadDatasetWithHttpInfo(client, project, artifact, identity, v, external, file).getBody();
    }

    /**
     * Import datasets
     * Import datasets
     * <p><b>200</b> - The imported result
     * <p><b>400</b> - Bad request
     * <p><b>401</b> - Unauthorized
     * <p><b>403</b> - Forbidden
     * <p><b>409</b> - Version Conflict
     * <p><b>500</b> - Backend Error
     * @param client Client name (required)
     * @param project Project name (required)
     * @param artifact Dataset name (required)
     * @param identity Unique row identifier (key) (required)
     * @param v Dataset version (optional)
     * @param external Document or collection (optional)
     * @param file File (optional)
     * @return ResponseEntity&lt;UploadResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<UploadResponse> uploadDatasetWithHttpInfo(String client, String project, String artifact, String identity, String v, String external, File file) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'client' is set
        if (client == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'client' when calling uploadDataset");
        }
        
        // verify the required parameter 'project' is set
        if (project == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'project' when calling uploadDataset");
        }
        
        // verify the required parameter 'artifact' is set
        if (artifact == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'artifact' when calling uploadDataset");
        }
        
        // verify the required parameter 'identity' is set
        if (identity == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'identity' when calling uploadDataset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("client", client);
        uriVariables.put("project", project);
        uriVariables.put("artifact", artifact);
        String path = apiClient.expandPath("/data/{client}/{project}/{artifact}/import", uriVariables);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap formParams = new LinkedMultiValueMap();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "v", v));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "identity", identity));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "external", external));

        if (file != null)
            formParams.add("file", new FileSystemResource(file));

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "multipart/form-data"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "api", "jwt", "oauth2" };

        ParameterizedTypeReference<UploadResponse> returnType = new ParameterizedTypeReference<UploadResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType);
    }
}
